/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.classic;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.QueryException;
import org.hibernate.hql.CollectionProperties;
import org.hibernate.hql.classic.ClauseParser;
import org.hibernate.hql.classic.Parser;
import org.hibernate.hql.classic.ParserHelper;
import org.hibernate.hql.classic.QueryTranslatorImpl;
import org.hibernate.util.StringHelper;

public class PreprocessingParser
implements Parser {
    private static final Set HQL_OPERATORS = new HashSet();
    private Map replacements;
    private boolean quoted;
    private StringBuffer quotedString;
    private ClauseParser parser = new ClauseParser();
    private String lastToken;
    private String currentCollectionProp;

    static {
        HQL_OPERATORS.add("<=");
        HQL_OPERATORS.add(">=");
        HQL_OPERATORS.add("=>");
        HQL_OPERATORS.add("=<");
        HQL_OPERATORS.add("!=");
        HQL_OPERATORS.add("<>");
        HQL_OPERATORS.add("!#");
        HQL_OPERATORS.add("!~");
        HQL_OPERATORS.add("!<");
        HQL_OPERATORS.add("!>");
        HQL_OPERATORS.add("is not");
        HQL_OPERATORS.add("not like");
        HQL_OPERATORS.add("not in");
        HQL_OPERATORS.add("not between");
        HQL_OPERATORS.add("not exists");
    }

    public PreprocessingParser(Map replacements) {
        this.replacements = replacements;
    }

    public void token(String token, QueryTranslatorImpl q) throws QueryException {
        if (this.quoted) {
            this.quotedString.append(token);
        }
        if ("'".equals(token)) {
            if (this.quoted) {
                token = this.quotedString.toString();
            } else {
                this.quotedString = new StringBuffer(20).append(token);
            }
            boolean bl = this.quoted = !this.quoted;
        }
        if (this.quoted) {
            return;
        }
        if (ParserHelper.isWhitespace(token)) {
            return;
        }
        String substoken = (String)this.replacements.get(token);
        String string = token = substoken == null ? token : substoken;
        if (this.currentCollectionProp != null) {
            if ("(".equals(token)) {
                return;
            }
            if (")".equals(token)) {
                this.currentCollectionProp = null;
                return;
            }
            token = StringHelper.qualify(token, this.currentCollectionProp);
        } else {
            String prop = CollectionProperties.getNormalizedPropertyName(token.toLowerCase());
            if (prop != null) {
                this.currentCollectionProp = prop;
                return;
            }
        }
        if (this.lastToken == null) {
            this.lastToken = token;
        } else {
            String doubleToken;
            String string2 = doubleToken = token.length() > 1 ? String.valueOf(this.lastToken) + ' ' + token : String.valueOf(this.lastToken) + token;
            if (HQL_OPERATORS.contains(doubleToken.toLowerCase())) {
                this.parser.token(doubleToken, q);
                this.lastToken = null;
            } else {
                this.parser.token(this.lastToken, q);
                this.lastToken = token;
            }
        }
    }

    public void start(QueryTranslatorImpl q) throws QueryException {
        this.quoted = false;
        this.parser.start(q);
    }

    public void end(QueryTranslatorImpl q) throws QueryException {
        if (this.lastToken != null) {
            this.parser.token(this.lastToken, q);
        }
        this.parser.end(q);
        this.lastToken = null;
        this.currentCollectionProp = null;
    }
}

