/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.hql.ast.tree.DisplayableNode;
import org.hibernate.hql.ast.tree.ExpectedTypeAwareNode;
import org.hibernate.hql.ast.tree.HqlSqlWalkerNode;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.type.Type;

public class ParameterNode
extends HqlSqlWalkerNode
implements DisplayableNode,
ExpectedTypeAwareNode {
    private ParameterSpecification parameterSpecification;

    public ParameterSpecification getHqlParameterSpecification() {
        return this.parameterSpecification;
    }

    public void setHqlParameterSpecification(ParameterSpecification parameterSpecification) {
        this.parameterSpecification = parameterSpecification;
    }

    public String getDisplayText() {
        return "{" + (this.parameterSpecification == null ? "???" : this.parameterSpecification.renderDisplayInfo()) + "}";
    }

    public void setExpectedType(Type expectedType) {
        this.getHqlParameterSpecification().setExpectedType(expectedType);
        this.setDataType(expectedType);
    }

    public Type getExpectedType() {
        return this.getHqlParameterSpecification() == null ? null : this.getHqlParameterSpecification().getExpectedType();
    }

    public String getRenderText(SessionFactoryImplementor sessionFactory) {
        int count = 0;
        if (this.getExpectedType() != null && (count = this.getExpectedType().getColumnSpan(sessionFactory)) > 1) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("(?");
            int i = 1;
            while (i < count) {
                buffer.append(", ?");
                ++i;
            }
            buffer.append(")");
            return buffer.toString();
        }
        return "?";
    }
}

