/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import antlr.SemanticException;
import antlr.collections.AST;
import org.hibernate.hql.ast.tree.BinaryLogicOperatorNode;
import org.hibernate.hql.ast.tree.BinaryOperatorNode;
import org.hibernate.hql.ast.tree.ExpectedTypeAwareNode;
import org.hibernate.hql.ast.tree.Node;
import org.hibernate.hql.ast.tree.SqlNode;
import org.hibernate.type.Type;

public class InLogicOperatorNode
extends BinaryLogicOperatorNode
implements BinaryOperatorNode {
    public Node getInList() {
        return this.getRightHandOperand();
    }

    public void initialize() throws SemanticException {
        Node lhs = this.getLeftHandOperand();
        if (lhs == null) {
            throw new SemanticException("left-hand operand of in operator was null");
        }
        Node inList = this.getInList();
        if (inList == null) {
            throw new SemanticException("right-hand operand of in operator was null");
        }
        if (SqlNode.class.isAssignableFrom(((Object)((Object)lhs)).getClass())) {
            Type lhsType = ((SqlNode)lhs).getDataType();
            AST inListChild = inList.getFirstChild();
            while (inListChild != null) {
                if (ExpectedTypeAwareNode.class.isAssignableFrom(inListChild.getClass())) {
                    ((ExpectedTypeAwareNode)inListChild).setExpectedType(lhsType);
                }
                inListChild = inListChild.getNextSibling();
            }
        }
    }
}

