/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import antlr.SemanticException;
import antlr.collections.AST;
import org.hibernate.hql.ast.tree.DisplayableNode;
import org.hibernate.hql.ast.tree.MethodNode;

public class CollectionFunction
extends MethodNode
implements DisplayableNode {
    public void resolve(boolean inSelect) throws SemanticException {
        this.initializeMethodNode((AST)this, inSelect);
        if (!this.isCollectionPropertyMethod()) {
            throw new SemanticException(String.valueOf(this.getText()) + " is not a collection property name!");
        }
        AST expr = this.getFirstChild();
        if (expr == null) {
            throw new SemanticException(String.valueOf(this.getText()) + " requires a path!");
        }
        this.resolveCollectionProperty(expr);
    }

    protected void prepareSelectColumns(String[] selectColumns) {
        String subselect = selectColumns[0].trim();
        if (subselect.startsWith("(") && subselect.endsWith(")")) {
            subselect = subselect.substring(1, subselect.length() - 1);
        }
        selectColumns[0] = subselect;
    }
}

