/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.exec;

import antlr.RecognitionException;
import antlr.collections.AST;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.hibernate.HibernateException;
import org.hibernate.action.BulkOperationCleanupAction;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.transaction.IsolatedWork;
import org.hibernate.engine.transaction.Isolater;
import org.hibernate.event.EventSource;
import org.hibernate.hql.ast.HqlSqlWalker;
import org.hibernate.hql.ast.SqlGenerator;
import org.hibernate.hql.ast.exec.StatementExecutor;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.InsertSelect;
import org.hibernate.sql.Select;
import org.hibernate.sql.SelectFragment;
import org.hibernate.util.StringHelper;

public abstract class AbstractStatementExecutor
implements StatementExecutor {
    private final Log log;
    private final HqlSqlWalker walker;

    public AbstractStatementExecutor(HqlSqlWalker walker, Log log) {
        this.walker = walker;
        this.log = log;
    }

    protected HqlSqlWalker getWalker() {
        return this.walker;
    }

    protected SessionFactoryImplementor getFactory() {
        return this.walker.getSessionFactoryHelper().getFactory();
    }

    protected abstract Queryable[] getAffectedQueryables();

    protected String generateIdInsertSelect(Queryable persister, String tableAlias, AST whereClause) {
        Select select = new Select(this.getFactory().getDialect());
        SelectFragment selectFragment = new SelectFragment().addColumns(tableAlias, persister.getIdentifierColumnNames(), persister.getIdentifierColumnNames());
        select.setSelectClause(selectFragment.toFragmentString().substring(2));
        String rootTableName = persister.getTableName();
        String fromJoinFragment = persister.fromJoinFragment(tableAlias, true, false);
        String whereJoinFragment = persister.whereJoinFragment(tableAlias, true, false);
        select.setFromClause(String.valueOf(rootTableName) + ' ' + tableAlias + fromJoinFragment);
        if (whereJoinFragment == null) {
            whereJoinFragment = "";
        } else if ((whereJoinFragment = whereJoinFragment.trim()).startsWith("and")) {
            whereJoinFragment = whereJoinFragment.substring(4);
        }
        String userWhereClause = "";
        if (whereClause.getNumberOfChildren() != 0) {
            try {
                SqlGenerator sqlGenerator = new SqlGenerator(this.getFactory());
                sqlGenerator.whereClause(whereClause);
                userWhereClause = sqlGenerator.getSQL().substring(7);
            }
            catch (RecognitionException e) {
                throw new HibernateException("Unable to generate id select for DML operation", e);
            }
            if (whereJoinFragment.length() > 0) {
                whereJoinFragment = String.valueOf(whereJoinFragment) + " and ";
            }
        }
        select.setWhereClause(String.valueOf(whereJoinFragment) + userWhereClause);
        InsertSelect insert = new InsertSelect(this.getFactory().getDialect());
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            insert.setComment("insert-select for " + persister.getEntityName() + " ids");
        }
        insert.setTableName(persister.getTemporaryIdTableName());
        insert.setSelect(select);
        return insert.toStatementString();
    }

    protected String generateIdSubselect(Queryable persister) {
        return "select " + StringHelper.join(", ", persister.getIdentifierColumnNames()) + " from " + persister.getTemporaryIdTableName();
    }

    protected void createTemporaryTableIfNecessary(final Queryable persister, SessionImplementor session) {
        IsolatedWork work = new IsolatedWork(){

            public void doWork(Connection connection) throws HibernateException {
                block12: {
                    Statement stmnt = null;
                    try {
                        try {
                            stmnt = connection.createStatement();
                            stmnt.executeUpdate(persister.getTemporaryIdTableDDL());
                        }
                        catch (Throwable t) {
                            AbstractStatementExecutor.this.log.debug((Object)("unable to create temporary id table [" + t.getMessage() + "]"));
                            if (stmnt == null) break block12;
                            try {
                                stmnt.close();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    finally {
                        if (stmnt != null) {
                            try {
                                stmnt.close();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                }
            }
        };
        if (this.shouldIsolateTemporaryTableDDL()) {
            if (this.getFactory().getSettings().isDataDefinitionInTransactionSupported()) {
                Isolater.doIsolatedWork(work, session);
            } else {
                Isolater.doNonTransactedWork(work, session);
            }
        } else {
            work.doWork(session.getJDBCContext().getConnectionManager().getConnection());
            session.getJDBCContext().getConnectionManager().afterStatement();
        }
    }

    protected void dropTemporaryTableIfNecessary(final Queryable persister, SessionImplementor session) {
        block20: {
            if (this.getFactory().getDialect().dropTemporaryTableAfterUse()) {
                IsolatedWork work = new IsolatedWork(){

                    public void doWork(Connection connection) throws HibernateException {
                        block12: {
                            Statement stmnt = null;
                            try {
                                try {
                                    stmnt = connection.createStatement();
                                    stmnt.executeUpdate("drop table " + persister.getTemporaryIdTableName());
                                }
                                catch (Throwable t) {
                                    AbstractStatementExecutor.this.log.warn((Object)("unable to drop temporary id table after use [" + t.getMessage() + "]"));
                                    if (stmnt == null) break block12;
                                    try {
                                        stmnt.close();
                                    }
                                    catch (Throwable throwable) {}
                                }
                            }
                            finally {
                                if (stmnt != null) {
                                    try {
                                        stmnt.close();
                                    }
                                    catch (Throwable throwable) {}
                                }
                            }
                        }
                    }
                };
                if (this.shouldIsolateTemporaryTableDDL()) {
                    if (this.getFactory().getSettings().isDataDefinitionInTransactionSupported()) {
                        Isolater.doIsolatedWork(work, session);
                    } else {
                        Isolater.doNonTransactedWork(work, session);
                    }
                } else {
                    work.doWork(session.getJDBCContext().getConnectionManager().getConnection());
                    session.getJDBCContext().getConnectionManager().afterStatement();
                }
            } else {
                PreparedStatement ps = null;
                try {
                    try {
                        ps = session.getBatcher().prepareStatement("delete from " + persister.getTemporaryIdTableName());
                        ps.executeUpdate();
                    }
                    catch (Throwable t) {
                        this.log.warn((Object)("unable to cleanup temporary id table after use [" + t + "]"));
                        if (ps != null) {
                            try {
                                session.getBatcher().closeStatement(ps);
                            }
                            catch (Throwable throwable) {}
                        }
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            session.getBatcher().closeStatement(ps);
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                if (ps != null) {
                    try {
                        session.getBatcher().closeStatement(ps);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected void coordinateSharedCacheCleanup(SessionImplementor session) {
        BulkOperationCleanupAction action = new BulkOperationCleanupAction(session, this.getAffectedQueryables());
        action.init();
        if (session.isEventSource()) {
            ((EventSource)session).getActionQueue().addAction(action);
        }
    }

    protected boolean shouldIsolateTemporaryTableDDL() {
        Boolean dialectVote = this.getFactory().getDialect().performTemporaryTableDDLInIsolation();
        if (dialectVote != null) {
            return dialectVote;
        }
        return this.getFactory().getSettings().isDataDefinitionImplicitCommit();
    }
}

