/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.exception;

import java.sql.SQLException;
import org.hibernate.JDBCException;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.util.JDBCExceptionReporter;

public final class JDBCExceptionHelper {
    private JDBCExceptionHelper() {
    }

    public static JDBCException convert(SQLExceptionConverter converter, SQLException sqlException, String message) {
        return JDBCExceptionHelper.convert(converter, sqlException, message, "???");
    }

    public static JDBCException convert(SQLExceptionConverter converter, SQLException sqlException, String message, String sql) {
        JDBCExceptionReporter.logExceptions(sqlException, String.valueOf(message) + " [" + sql + "]");
        return converter.convert(sqlException, message, sql);
    }

    public static int extractErrorCode(SQLException sqlException) {
        int errorCode = sqlException.getErrorCode();
        SQLException nested = sqlException.getNextException();
        while (errorCode == 0 && nested != null) {
            errorCode = nested.getErrorCode();
            nested = nested.getNextException();
        }
        return errorCode;
    }

    public static String extractSqlState(SQLException sqlException) {
        String sqlState = sqlException.getSQLState();
        SQLException nested = sqlException.getNextException();
        while (sqlState == null && nested != null) {
            sqlState = nested.getSQLState();
            nested = nested.getNextException();
        }
        return sqlState;
    }

    public static String extractSqlStateClassCode(SQLException sqlException) {
        return JDBCExceptionHelper.determineSqlStateClassCode(JDBCExceptionHelper.extractSqlState(sqlException));
    }

    public static String determineSqlStateClassCode(String sqlState) {
        if (sqlState == null || sqlState.length() < 2) {
            return sqlState;
        }
        return sqlState.substring(0, 2);
    }
}

