/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.exception;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.JDBCException;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.DataException;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.exception.ViolatedConstraintNameExtracter;

public class CacheSQLStateConverter
implements SQLExceptionConverter {
    private ViolatedConstraintNameExtracter extracter;
    private static final Set SQL_GRAMMAR_CATEGORIES = new HashSet();
    private static final Set DATA_CATEGORIES = new HashSet();
    private static final Set INTEGRITY_VIOLATION_CATEGORIES = new HashSet();
    private static final Set CONNECTION_CATEGORIES = new HashSet();

    static {
        SQL_GRAMMAR_CATEGORIES.add("07");
        SQL_GRAMMAR_CATEGORIES.add("37");
        SQL_GRAMMAR_CATEGORIES.add("42");
        SQL_GRAMMAR_CATEGORIES.add("65");
        SQL_GRAMMAR_CATEGORIES.add("S0");
        SQL_GRAMMAR_CATEGORIES.add("20");
        DATA_CATEGORIES.add("22");
        DATA_CATEGORIES.add("21");
        DATA_CATEGORIES.add("02");
        INTEGRITY_VIOLATION_CATEGORIES.add(new Integer(119));
        INTEGRITY_VIOLATION_CATEGORIES.add(new Integer(120));
        INTEGRITY_VIOLATION_CATEGORIES.add(new Integer(121));
        INTEGRITY_VIOLATION_CATEGORIES.add(new Integer(122));
        INTEGRITY_VIOLATION_CATEGORIES.add(new Integer(123));
        INTEGRITY_VIOLATION_CATEGORIES.add(new Integer(124));
        INTEGRITY_VIOLATION_CATEGORIES.add(new Integer(125));
        INTEGRITY_VIOLATION_CATEGORIES.add(new Integer(127));
        CONNECTION_CATEGORIES.add("08");
    }

    public CacheSQLStateConverter(ViolatedConstraintNameExtracter extracter) {
        this.extracter = extracter;
    }

    public JDBCException convert(SQLException sqlException, String message, String sql) {
        String sqlStateClassCode = JDBCExceptionHelper.extractSqlStateClassCode(sqlException);
        Integer errorCode = new Integer(JDBCExceptionHelper.extractErrorCode(sqlException));
        if (sqlStateClassCode != null) {
            if (SQL_GRAMMAR_CATEGORIES.contains(sqlStateClassCode)) {
                return new SQLGrammarException(message, sqlException, sql);
            }
            if (INTEGRITY_VIOLATION_CATEGORIES.contains(errorCode)) {
                String constraintName = this.extracter.extractConstraintName(sqlException);
                return new ConstraintViolationException(message, sqlException, sql, constraintName);
            }
            if (CONNECTION_CATEGORIES.contains(sqlStateClassCode)) {
                return new JDBCConnectionException(message, sqlException, sql);
            }
            if (DATA_CATEGORIES.contains(sqlStateClassCode)) {
                return new DataException(message, sqlException, sql);
            }
        }
        return this.handledNonSpecificException(sqlException, message, sql);
    }

    protected JDBCException handledNonSpecificException(SQLException sqlException, String message, String sql) {
        return new GenericJDBCException(message, sqlException, sql);
    }
}

