/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.event.DirtyCheckEvent;
import org.hibernate.event.DirtyCheckEventListener;
import org.hibernate.event.def.AbstractFlushingEventListener;

public class DefaultDirtyCheckEventListener
extends AbstractFlushingEventListener
implements DirtyCheckEventListener {
    private static final Log log = LogFactory.getLog(DefaultDirtyCheckEventListener.class);

    public void onDirtyCheck(DirtyCheckEvent event) throws HibernateException {
        int oldSize = event.getSession().getActionQueue().numberOfCollectionRemovals();
        try {
            this.flushEverythingToExecutions(event);
            boolean wasNeeded = event.getSession().getActionQueue().hasAnyQueuedActions();
            log.debug((Object)(wasNeeded ? "session dirty" : "session not dirty"));
            event.setDirty(wasNeeded);
        }
        finally {
            event.getSession().getActionQueue().clearFromFlushNeededCheck(oldSize);
        }
    }
}

