/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.query;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.query.FilterQueryPlan;
import org.hibernate.engine.query.HQLQueryPlan;
import org.hibernate.engine.query.NamedParameterDescriptor;
import org.hibernate.engine.query.NativeSQLQueryPlan;
import org.hibernate.engine.query.OrdinalParameterDescriptor;
import org.hibernate.engine.query.ParamLocationRecognizer;
import org.hibernate.engine.query.ParameterMetadata;
import org.hibernate.engine.query.sql.NativeSQLQuerySpecification;
import org.hibernate.util.SimpleMRUCache;
import org.hibernate.util.SoftLimitMRUCache;

public class QueryPlanCache
implements Serializable {
    private static final Log log = LogFactory.getLog(QueryPlanCache.class);
    private SessionFactoryImplementor factory;
    private final SimpleMRUCache sqlParamMetadataCache = new SimpleMRUCache();
    private final SoftLimitMRUCache planCache = new SoftLimitMRUCache(128);

    public QueryPlanCache(SessionFactoryImplementor factory) {
        this.factory = factory;
    }

    public ParameterMetadata getSQLParameterMetadata(String query) {
        ParameterMetadata metadata = (ParameterMetadata)this.sqlParamMetadataCache.get(query);
        if (metadata == null) {
            metadata = this.buildNativeSQLParameterMetadata(query);
            this.sqlParamMetadataCache.put(query, metadata);
        }
        return metadata;
    }

    public HQLQueryPlan getHQLQueryPlan(String queryString, boolean shallow, Map enabledFilters) throws QueryException, MappingException {
        HQLQueryPlanKey key = new HQLQueryPlanKey(queryString, shallow, enabledFilters);
        HQLQueryPlan plan = (HQLQueryPlan)this.planCache.get(key);
        if (plan == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("unable to locate HQL query plan in cache; generating (" + queryString + ")"));
            }
            plan = new HQLQueryPlan(queryString, shallow, enabledFilters, this.factory);
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("located HQL query plan in cache (" + queryString + ")"));
        }
        this.planCache.put(key, plan);
        return plan;
    }

    public FilterQueryPlan getFilterQueryPlan(String filterString, String collectionRole, boolean shallow, Map enabledFilters) throws QueryException, MappingException {
        FilterQueryPlanKey key = new FilterQueryPlanKey(filterString, collectionRole, shallow, enabledFilters);
        FilterQueryPlan plan = (FilterQueryPlan)this.planCache.get(key);
        if (plan == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("unable to locate collection-filter query plan in cache; generating (" + collectionRole + " : " + filterString + ")"));
            }
            plan = new FilterQueryPlan(filterString, collectionRole, shallow, enabledFilters, this.factory);
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("located collection-filter query plan in cache (" + collectionRole + " : " + filterString + ")"));
        }
        this.planCache.put(key, plan);
        return plan;
    }

    public NativeSQLQueryPlan getNativeSQLQueryPlan(NativeSQLQuerySpecification spec) {
        NativeSQLQueryPlan plan = (NativeSQLQueryPlan)this.planCache.get(spec);
        if (plan == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("unable to locate native-sql query plan in cache; generating (" + spec.getQueryString() + ")"));
            }
            plan = new NativeSQLQueryPlan(spec, this.factory);
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("located native-sql query plan in cache (" + spec.getQueryString() + ")"));
        }
        this.planCache.put(spec, plan);
        return plan;
    }

    private ParameterMetadata buildNativeSQLParameterMetadata(String sqlString) {
        ParamLocationRecognizer recognizer = ParamLocationRecognizer.parseLocations(sqlString);
        OrdinalParameterDescriptor[] ordinalDescriptors = new OrdinalParameterDescriptor[recognizer.getOrdinalParameterLocationList().size()];
        int i = 0;
        while (i < recognizer.getOrdinalParameterLocationList().size()) {
            Integer position = (Integer)recognizer.getOrdinalParameterLocationList().get(i);
            ordinalDescriptors[i] = new OrdinalParameterDescriptor(i, null, position);
            ++i;
        }
        Iterator itr = recognizer.getNamedParameterDescriptionMap().entrySet().iterator();
        HashMap<String, NamedParameterDescriptor> namedParamDescriptorMap = new HashMap<String, NamedParameterDescriptor>();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            String name = (String)entry.getKey();
            ParamLocationRecognizer.NamedParameterDescription description = (ParamLocationRecognizer.NamedParameterDescription)entry.getValue();
            namedParamDescriptorMap.put(name, new NamedParameterDescriptor(name, null, description.buildPositionsArray(), description.isJpaStyle()));
        }
        return new ParameterMetadata(ordinalDescriptors, namedParamDescriptorMap);
    }

    private static class FilterQueryPlanKey
    implements Serializable {
        private final String query;
        private final String collectionRole;
        private final boolean shallow;
        private final Set filterNames;
        private final int hashCode;

        public FilterQueryPlanKey(String query, String collectionRole, boolean shallow, Map enabledFilters) {
            this.query = query;
            this.collectionRole = collectionRole;
            this.shallow = shallow;
            if (enabledFilters == null || enabledFilters.isEmpty()) {
                this.filterNames = Collections.EMPTY_SET;
            } else {
                HashSet tmp = new HashSet();
                tmp.addAll(enabledFilters.keySet());
                this.filterNames = Collections.unmodifiableSet(tmp);
            }
            int hash = query.hashCode();
            hash = 29 * hash + collectionRole.hashCode();
            hash = 29 * hash + (shallow ? 1 : 0);
            this.hashCode = hash = 29 * hash + this.filterNames.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilterQueryPlanKey that = (FilterQueryPlanKey)o;
            if (this.shallow != that.shallow) {
                return false;
            }
            if (!this.filterNames.equals(that.filterNames)) {
                return false;
            }
            if (!this.query.equals(that.query)) {
                return false;
            }
            return this.collectionRole.equals(that.collectionRole);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static class HQLQueryPlanKey
    implements Serializable {
        private final String query;
        private final boolean shallow;
        private final Set filterNames;
        private final int hashCode;

        public HQLQueryPlanKey(String query, boolean shallow, Map enabledFilters) {
            this.query = query;
            this.shallow = shallow;
            if (enabledFilters == null || enabledFilters.isEmpty()) {
                this.filterNames = Collections.EMPTY_SET;
            } else {
                HashSet tmp = new HashSet();
                tmp.addAll(enabledFilters.keySet());
                this.filterNames = Collections.unmodifiableSet(tmp);
            }
            int hash = query.hashCode();
            hash = 29 * hash + (shallow ? 1 : 0);
            this.hashCode = hash = 29 * hash + this.filterNames.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HQLQueryPlanKey that = (HQLQueryPlanKey)o;
            if (this.shallow != that.shallow) {
                return false;
            }
            if (!this.filterNames.equals(that.filterNames)) {
                return false;
            }
            return this.query.equals(that.query);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

