/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.type.Type;

public class VarArgsSQLFunction
implements SQLFunction {
    private final String begin;
    private final String sep;
    private final String end;
    private final Type type;

    public VarArgsSQLFunction(Type type, String begin, String sep, String end) {
        this.begin = begin;
        this.sep = sep;
        this.end = end;
        this.type = type;
    }

    public VarArgsSQLFunction(String begin, String sep, String end) {
        this.begin = begin;
        this.sep = sep;
        this.end = end;
        this.type = null;
    }

    public Type getReturnType(Type columnType, Mapping mapping) throws QueryException {
        return this.type == null ? columnType : this.type;
    }

    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return true;
    }

    public String render(List args, SessionFactoryImplementor factory) throws QueryException {
        StringBuffer buf = new StringBuffer().append(this.begin);
        int i = 0;
        while (i < args.size()) {
            buf.append(args.get(i));
            if (i < args.size() - 1) {
                buf.append(this.sep);
            }
            ++i;
        }
        return buf.append(this.end).toString();
    }
}

