/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.type.Type;

public class ConditionalParenthesisFunction
extends StandardSQLFunction {
    public ConditionalParenthesisFunction(String name) {
        super(name);
    }

    public ConditionalParenthesisFunction(String name, Type type) {
        super(name, type);
    }

    public boolean hasParenthesesIfNoArguments() {
        return false;
    }

    public String render(List args, SessionFactoryImplementor factory) {
        boolean hasArgs = !args.isEmpty();
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName());
        if (hasArgs) {
            buf.append("(");
            int i = 0;
            while (i < args.size()) {
                buf.append(args.get(i));
                if (i < args.size() - 1) {
                    buf.append(", ");
                }
                ++i;
            }
            buf.append(")");
        }
        return buf.toString();
    }
}

