/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import java.io.Serializable;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.type.Type;

public class Order
implements Serializable {
    private boolean ascending;
    private boolean ignoreCase;
    private String propertyName;

    public String toString() {
        return String.valueOf(this.propertyName) + ' ' + (this.ascending ? "asc" : "desc");
    }

    public Order ignoreCase() {
        this.ignoreCase = true;
        return this;
    }

    protected Order(String propertyName, boolean ascending) {
        this.propertyName = propertyName;
        this.ascending = ascending;
    }

    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        String[] columns = criteriaQuery.getColumnsUsingProjection(criteria, this.propertyName);
        Type type = criteriaQuery.getTypeUsingProjection(criteria, this.propertyName);
        StringBuffer fragment = new StringBuffer();
        int i = 0;
        while (i < columns.length) {
            boolean lower;
            SessionFactoryImplementor factory = criteriaQuery.getFactory();
            boolean bl = lower = this.ignoreCase && type.sqlTypes(factory)[i] == 12;
            if (lower) {
                fragment.append(factory.getDialect().getLowercaseFunction()).append('(');
            }
            fragment.append(columns[i]);
            if (lower) {
                fragment.append(')');
            }
            fragment.append(this.ascending ? " asc" : " desc");
            if (i < columns.length - 1) {
                fragment.append(", ");
            }
            ++i;
        }
        return fragment.toString();
    }

    public static Order asc(String propertyName) {
        return new Order(propertyName, true);
    }

    public static Order desc(String propertyName) {
        return new Order(propertyName, false);
    }
}

