/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class MatchMode
implements Serializable {
    private final String name;
    private static final Map INSTANCES = new HashMap();
    public static final MatchMode EXACT = new MatchMode("EXACT"){

        public String toMatchString(String pattern) {
            return pattern;
        }
    };
    public static final MatchMode START = new MatchMode("START"){

        public String toMatchString(String pattern) {
            return String.valueOf(pattern) + '%';
        }
    };
    public static final MatchMode END = new MatchMode("END"){

        public String toMatchString(String pattern) {
            return String.valueOf('%') + pattern;
        }
    };
    public static final MatchMode ANYWHERE = new MatchMode("ANYWHERE"){

        public String toMatchString(String pattern) {
            return String.valueOf('%') + pattern + '%';
        }
    };

    static {
        INSTANCES.put(MatchMode.EXACT.name, EXACT);
        INSTANCES.put(MatchMode.END.name, END);
        INSTANCES.put(MatchMode.START.name, START);
        INSTANCES.put(MatchMode.ANYWHERE.name, ANYWHERE);
    }

    protected MatchMode(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    private Object readResolve() {
        return INSTANCES.get(this.name);
    }

    public abstract String toMatchString(String var1);
}

