/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.hibernate.EntityMode;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.RowSelection;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.Type;
import org.hibernate.util.EqualsHelper;

public class QueryKey
implements Serializable {
    private final String sqlQueryString;
    private final Type[] types;
    private final Object[] values;
    private final Integer firstRow;
    private final Integer maxRows;
    private final Map namedParameters;
    private final EntityMode entityMode;
    private final Set filters;
    private final int hashCode;
    private final ResultTransformer customTransformer;

    public QueryKey(String queryString, QueryParameters queryParameters, Set filters, EntityMode entityMode) {
        this.sqlQueryString = queryString;
        this.types = queryParameters.getPositionalParameterTypes();
        this.values = queryParameters.getPositionalParameterValues();
        RowSelection selection = queryParameters.getRowSelection();
        if (selection != null) {
            this.firstRow = selection.getFirstRow();
            this.maxRows = selection.getMaxRows();
        } else {
            this.firstRow = null;
            this.maxRows = null;
        }
        this.namedParameters = queryParameters.getNamedParameters();
        this.entityMode = entityMode;
        this.filters = filters;
        this.customTransformer = queryParameters.getResultTransformer();
        this.hashCode = this.getHashCode();
    }

    public boolean equals(Object other) {
        QueryKey that = (QueryKey)other;
        if (!this.sqlQueryString.equals(that.sqlQueryString)) {
            return false;
        }
        if (!EqualsHelper.equals(this.firstRow, that.firstRow) || !EqualsHelper.equals(this.maxRows, that.maxRows)) {
            return false;
        }
        if (!EqualsHelper.equals(this.customTransformer, that.customTransformer)) {
            return false;
        }
        if (this.types == null) {
            if (that.types != null) {
                return false;
            }
        } else {
            if (that.types == null) {
                return false;
            }
            if (this.types.length != that.types.length) {
                return false;
            }
            int i = 0;
            while (i < this.types.length) {
                if (this.types[i].getReturnedClass() != that.types[i].getReturnedClass()) {
                    return false;
                }
                if (!this.types[i].isEqual(this.values[i], that.values[i], this.entityMode)) {
                    return false;
                }
                ++i;
            }
        }
        if (!EqualsHelper.equals(this.filters, that.filters)) {
            return false;
        }
        return EqualsHelper.equals(this.namedParameters, that.namedParameters);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int getHashCode() {
        int result = 13;
        result = 37 * result + (this.firstRow == null ? 0 : this.firstRow.hashCode());
        result = 37 * result + (this.maxRows == null ? 0 : this.maxRows.hashCode());
        int i = 0;
        while (i < this.values.length) {
            result = 37 * result + (this.values[i] == null ? 0 : this.types[i].getHashCode(this.values[i], this.entityMode));
            ++i;
        }
        result = 37 * result + (this.namedParameters == null ? 0 : this.namedParameters.hashCode());
        result = 37 * result + (this.filters == null ? 0 : this.filters.hashCode());
        result = 37 * result + (this.customTransformer == null ? 0 : this.customTransformer.hashCode());
        result = 37 * result + this.sqlQueryString.hashCode();
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer().append("sql: ").append(this.sqlQueryString);
        if (this.values != null) {
            buf.append("; parameters: ");
            int i = 0;
            while (i < this.values.length) {
                buf.append(this.values[i]).append(", ");
                ++i;
            }
        }
        if (this.namedParameters != null) {
            buf.append("; named parameters: ").append(this.namedParameters);
        }
        if (this.filters != null) {
            buf.append("; filters: ").append(this.filters);
        }
        if (this.firstRow != null) {
            buf.append("; first row: ").append(this.firstRow);
        }
        if (this.maxRows != null) {
            buf.append("; max rows: ").append(this.maxRows);
        }
        if (this.customTransformer != null) {
            buf.append("; transformer: ").append(this.customTransformer);
        }
        return buf.toString();
    }
}

