/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.javassist;

import java.io.IOException;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import org.hibernate.HibernateException;

public class TransformingClassLoader
extends ClassLoader {
    private ClassLoader parent;
    private ClassPool classPool;

    TransformingClassLoader(ClassLoader parent, String[] classpath) {
        this.parent = parent;
        this.classPool = new ClassPool(true);
        int i = 0;
        while (i < classpath.length) {
            try {
                this.classPool.appendClassPath(classpath[i]);
            }
            catch (NotFoundException e) {
                throw new HibernateException("Unable to resolve requested classpath for transformation [" + classpath[i] + "] : " + e.getMessage());
            }
            ++i;
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        try {
            CtClass cc = this.classPool.get(name);
            byte[] b = cc.toBytecode();
            return this.defineClass(name, b, 0, b.length);
        }
        catch (NotFoundException e) {
            throw new ClassNotFoundException();
        }
        catch (IOException e) {
            throw new ClassNotFoundException();
        }
        catch (CannotCompileException e) {
            throw new ClassNotFoundException();
        }
    }

    public void release() {
        this.classPool = null;
        this.parent = null;
    }
}

