/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.javassist;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.security.ProtectionDomain;
import javassist.bytecode.ClassFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.AbstractClassTransformerImpl;
import org.hibernate.bytecode.javassist.FieldFilter;
import org.hibernate.bytecode.javassist.FieldHandled;
import org.hibernate.bytecode.javassist.FieldTransformer;
import org.hibernate.bytecode.util.ClassFilter;

public class JavassistClassTransformer
extends AbstractClassTransformerImpl {
    private static Log log = LogFactory.getLog((String)JavassistClassTransformer.class.getName());

    public JavassistClassTransformer(ClassFilter classFilter, org.hibernate.bytecode.util.FieldFilter fieldFilter) {
        super(classFilter, fieldFilter);
    }

    protected byte[] doTransform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        ClassFile classfile;
        try {
            classfile = new ClassFile(new DataInputStream(new ByteArrayInputStream(classfileBuffer)));
        }
        catch (IOException e) {
            log.error((Object)("Unable to build enhancement metamodel for " + className));
            return classfileBuffer;
        }
        FieldTransformer transformer = this.getFieldTransformer(classfile);
        if (transformer != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Enhancing " + className));
            }
            FilterOutputStream out = null;
            try {
                transformer.transform(classfile);
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                out = new DataOutputStream(byteStream);
                classfile.write((DataOutputStream)out);
                byte[] byArray = byteStream.toByteArray();
                return byArray;
            }
            catch (Exception e) {
                log.error((Object)"Unable to transform class", (Throwable)e);
                throw new HibernateException("Unable to transform class: " + e.getMessage());
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return classfileBuffer;
    }

    protected FieldTransformer getFieldTransformer(final ClassFile classfile) {
        if (this.alreadyInstrumented(classfile)) {
            return null;
        }
        return new FieldTransformer(new FieldFilter(){

            public boolean handleRead(String desc, String name) {
                return JavassistClassTransformer.this.fieldFilter.shouldInstrumentField(classfile.getName(), name);
            }

            public boolean handleWrite(String desc, String name) {
                return JavassistClassTransformer.this.fieldFilter.shouldInstrumentField(classfile.getName(), name);
            }

            public boolean handleReadAccess(String fieldOwnerClassName, String fieldName) {
                return JavassistClassTransformer.this.fieldFilter.shouldTransformFieldAccess(classfile.getName(), fieldOwnerClassName, fieldName);
            }

            public boolean handleWriteAccess(String fieldOwnerClassName, String fieldName) {
                return JavassistClassTransformer.this.fieldFilter.shouldTransformFieldAccess(classfile.getName(), fieldOwnerClassName, fieldName);
            }
        });
    }

    private boolean alreadyInstrumented(ClassFile classfile) {
        String[] intfs = classfile.getInterfaces();
        int i = 0;
        while (i < intfs.length) {
            if (FieldHandled.class.getName().equals(intfs[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

