/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.javassist;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class FastClass
implements Serializable {
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private Class type;

    private FastClass() {
    }

    private FastClass(Class type) {
        this.type = type;
    }

    public Object invoke(String name, Class[] parameterTypes, Object obj, Object[] args) throws InvocationTargetException {
        return this.invoke(this.getIndex(name, parameterTypes), obj, args);
    }

    public Object invoke(int index, Object obj, Object[] args) throws InvocationTargetException {
        Method[] methods = this.type.getMethods();
        try {
            return methods[index].invoke(obj, args);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Cannot find matching method/constructor");
        }
        catch (IllegalAccessException e) {
            throw new InvocationTargetException(e);
        }
    }

    public Object newInstance() throws InvocationTargetException {
        return this.newInstance(this.getIndex(EMPTY_CLASS_ARRAY), null);
    }

    public Object newInstance(Class[] parameterTypes, Object[] args) throws InvocationTargetException {
        return this.newInstance(this.getIndex(parameterTypes), args);
    }

    public Object newInstance(int index, Object[] args) throws InvocationTargetException {
        Constructor<?>[] conss = this.type.getConstructors();
        try {
            return conss[index].newInstance(args);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Cannot find matching method/constructor");
        }
        catch (InstantiationException e) {
            throw new InvocationTargetException(e);
        }
        catch (IllegalAccessException e) {
            throw new InvocationTargetException(e);
        }
    }

    public int getIndex(String name, Class[] parameterTypes) {
        Method[] methods = this.type.getMethods();
        boolean eq = true;
        int i = 0;
        while (i < methods.length) {
            Class<?>[] params;
            if (Modifier.isPublic(methods[i].getModifiers()) && methods[i].getName().equals(name) && (params = methods[i].getParameterTypes()).length == parameterTypes.length) {
                eq = true;
                int j = 0;
                while (j < params.length) {
                    if (!params[j].equals(parameterTypes[j])) {
                        eq = false;
                        break;
                    }
                    ++j;
                }
                if (eq) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public int getIndex(Class[] parameterTypes) {
        Constructor<?>[] conss = this.type.getConstructors();
        boolean eq = true;
        int i = 0;
        while (i < conss.length) {
            Class<?>[] params;
            if (Modifier.isPublic(conss[i].getModifiers()) && (params = conss[i].getParameterTypes()).length == parameterTypes.length) {
                eq = true;
                int j = 0;
                while (j < params.length) {
                    if (!params[j].equals(parameterTypes[j])) {
                        eq = false;
                        break;
                    }
                    ++j;
                }
                if (eq) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public int getMaxIndex() {
        Method[] methods = this.type.getMethods();
        int count = 0;
        int i = 0;
        while (i < methods.length) {
            if (Modifier.isPublic(methods[i].getModifiers())) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public String getName() {
        return this.type.getName();
    }

    public Class getJavaClass() {
        return this.type;
    }

    public String toString() {
        return this.type.toString();
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof FastClass)) {
            return false;
        }
        return this.type.equals(((FastClass)o).type);
    }

    public static FastClass create(Class type) {
        FastClass fc = new FastClass(type);
        return fc;
    }
}

