/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.cglib;

import java.lang.reflect.Method;
import java.util.HashMap;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.BasicProxyFactory;
import org.hibernate.bytecode.ProxyFactoryFactory;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.proxy.pojo.cglib.CGLIBProxyFactory;

public class ProxyFactoryFactoryImpl
implements ProxyFactoryFactory {
    private static final CallbackFilter FINALIZE_FILTER = new CallbackFilter(){

        public int accept(Method method) {
            if (method.getParameterTypes().length == 0 && method.getName().equals("finalize")) {
                return 1;
            }
            return 0;
        }
    };
    private static final Class[] CALLBACK_TYPES = new Class[]{MethodInterceptor.class, NoOp.class};

    public ProxyFactory buildProxyFactory() {
        return new CGLIBProxyFactory();
    }

    public BasicProxyFactory buildBasicProxyFactory(Class superClass, Class[] interfaces) {
        return new BasicProxyFactoryImpl(superClass, interfaces);
    }

    public static class BasicProxyFactoryImpl
    implements BasicProxyFactory {
        private final Class proxyClass;
        private final Factory factory;

        public BasicProxyFactoryImpl(Class superClass, Class[] interfaces) {
            if (superClass == null && (interfaces == null || interfaces.length < 1)) {
                throw new AssertionFailure("attempting to build proxy without any superclass or interfaces");
            }
            Enhancer en = new Enhancer();
            en.setUseCache(false);
            en.setInterceptDuringConstruction(false);
            en.setUseFactory(true);
            en.setCallbackTypes(CALLBACK_TYPES);
            en.setCallbackFilter(FINALIZE_FILTER);
            if (superClass != null) {
                en.setSuperclass(superClass);
            }
            if (interfaces != null && interfaces.length > 0) {
                en.setInterfaces(interfaces);
            }
            this.proxyClass = en.createClass();
            try {
                this.factory = (Factory)this.proxyClass.newInstance();
            }
            catch (Throwable t) {
                throw new HibernateException("Unable to build CGLIB Factory instance");
            }
        }

        public Object getProxy() {
            try {
                return this.factory.newInstance(new Callback[]{new PassThroughInterceptor(this.proxyClass.getName()), NoOp.INSTANCE});
            }
            catch (Throwable t) {
                throw new HibernateException("Unable to instantiate proxy instance");
            }
        }
    }

    private static class PassThroughInterceptor
    implements MethodInterceptor {
        private HashMap data = new HashMap();
        private final String proxiedClassName;

        public PassThroughInterceptor(String proxiedClassName) {
            this.proxiedClassName = proxiedClassName;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            boolean hasSetterSignature;
            String name = method.getName();
            if ("toString".equals(name)) {
                return String.valueOf(this.proxiedClassName) + "@" + System.identityHashCode(obj);
            }
            if ("equals".equals(name)) {
                return args[0] instanceof Factory && ((Factory)args[0]).getCallback(0) == this ? Boolean.TRUE : Boolean.FALSE;
            }
            if ("hashCode".equals(name)) {
                return new Integer(System.identityHashCode(obj));
            }
            boolean hasGetterSignature = method.getParameterTypes().length == 0 && method.getReturnType() != null;
            boolean bl = hasSetterSignature = method.getParameterTypes().length == 1 && (method.getReturnType() == null || method.getReturnType() == Void.TYPE);
            if (name.startsWith("get") && hasGetterSignature) {
                String propName = name.substring(3);
                return this.data.get(propName);
            }
            if (name.startsWith("is") && hasGetterSignature) {
                String propName = name.substring(2);
                return this.data.get(propName);
            }
            if (name.startsWith("set") && hasSetterSignature) {
                String propName = name.substring(3);
                this.data.put(propName, args[0]);
                return null;
            }
            return null;
        }
    }
}

