/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.cglib;

import java.lang.reflect.Modifier;
import net.sf.cglib.beans.BulkBean;
import net.sf.cglib.beans.BulkBeanException;
import net.sf.cglib.reflect.FastClass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.bytecode.BytecodeProvider;
import org.hibernate.bytecode.ClassTransformer;
import org.hibernate.bytecode.ProxyFactoryFactory;
import org.hibernate.bytecode.ReflectionOptimizer;
import org.hibernate.bytecode.cglib.AccessOptimizerAdapter;
import org.hibernate.bytecode.cglib.CglibClassTransformer;
import org.hibernate.bytecode.cglib.InstantiationOptimizerAdapter;
import org.hibernate.bytecode.cglib.ProxyFactoryFactoryImpl;
import org.hibernate.bytecode.cglib.ReflectionOptimizerImpl;
import org.hibernate.bytecode.util.ClassFilter;
import org.hibernate.bytecode.util.FieldFilter;
import org.hibernate.util.StringHelper;

public class BytecodeProviderImpl
implements BytecodeProvider {
    private static final Log log = LogFactory.getLog(BytecodeProviderImpl.class);

    public ProxyFactoryFactory getProxyFactoryFactory() {
        return new ProxyFactoryFactoryImpl();
    }

    public ReflectionOptimizer getReflectionOptimizer(Class clazz, String[] getterNames, String[] setterNames, Class[] types) {
        BulkBean bulkBean;
        FastClass fastClass;
        try {
            fastClass = FastClass.create((Class)clazz);
            bulkBean = BulkBean.create((Class)clazz, (String[])getterNames, (String[])setterNames, (Class[])types);
            if (!clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())) {
                if (fastClass == null) {
                    bulkBean = null;
                } else {
                    Object instance = fastClass.newInstance();
                    bulkBean.setPropertyValues(instance, bulkBean.getPropertyValues(instance));
                }
            }
        }
        catch (Throwable t) {
            int index;
            fastClass = null;
            bulkBean = null;
            String message = "reflection optimizer disabled for: " + clazz.getName() + " [" + StringHelper.unqualify(t.getClass().getName()) + ": " + t.getMessage();
            if (t instanceof BulkBeanException && (index = ((BulkBeanException)t).getIndex()) >= 0) {
                message = String.valueOf(message) + " (property " + setterNames[index] + ")";
            }
            log.debug((Object)message);
        }
        if (fastClass != null && bulkBean != null) {
            return new ReflectionOptimizerImpl(new InstantiationOptimizerAdapter(fastClass), new AccessOptimizerAdapter(bulkBean, clazz));
        }
        return null;
    }

    public ClassTransformer getTransformer(ClassFilter classFilter, FieldFilter fieldFilter) {
        return new CglibClassTransformer(classFilter, fieldFilter);
    }
}

