/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode;

import java.io.InputStream;
import org.hibernate.bytecode.ClassTransformer;
import org.hibernate.bytecode.util.ByteCodeHelper;

public class InstrumentedClassLoader
extends ClassLoader {
    private ClassTransformer classTransformer;

    public InstrumentedClassLoader(ClassLoader parent, ClassTransformer classTransformer) {
        super(parent);
        this.classTransformer = classTransformer;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        if (name.startsWith("java.") || this.classTransformer == null) {
            return this.getParent().loadClass(name);
        }
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        InputStream is = this.getResourceAsStream(String.valueOf(name.replace('.', '/')) + ".class");
        if (is == null) {
            throw new ClassNotFoundException(String.valueOf(name) + " not found");
        }
        try {
            byte[] originalBytecode = ByteCodeHelper.readByteCode(is);
            byte[] transformedBytecode = this.classTransformer.transform(this.getParent(), name, null, null, originalBytecode);
            if (originalBytecode == transformedBytecode) {
                return this.getParent().loadClass(name);
            }
            return this.defineClass(name, transformedBytecode, 0, transformedBytecode.length);
        }
        catch (Throwable t) {
            throw new ClassNotFoundException(String.valueOf(name) + " not found", t);
        }
    }
}

