/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.action.Executable;
import org.hibernate.cache.OptimisticTreeCacheProvider;
import org.hibernate.cache.TreeCacheProvider;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Queryable;

public class BulkOperationCleanupAction
implements Executable,
Serializable {
    private final SessionImplementor session;
    private final Set affectedEntityNames = new HashSet();
    private final Set affectedCollectionRoles = new HashSet();
    private final Serializable[] spaces;

    public BulkOperationCleanupAction(SessionImplementor session, Queryable[] affectedQueryables) {
        this.session = session;
        ArrayList<Serializable> tmpSpaces = new ArrayList<Serializable>();
        int i = 0;
        while (i < affectedQueryables.length) {
            Set roles;
            if (affectedQueryables[i].hasCache()) {
                this.affectedEntityNames.add(affectedQueryables[i].getEntityName());
            }
            if ((roles = session.getFactory().getCollectionRolesByEntityParticipant(affectedQueryables[i].getEntityName())) != null) {
                this.affectedCollectionRoles.addAll(roles);
            }
            int y = 0;
            while (y < affectedQueryables[i].getQuerySpaces().length) {
                tmpSpaces.add(affectedQueryables[i].getQuerySpaces()[y]);
                ++y;
            }
            ++i;
        }
        this.spaces = new Serializable[tmpSpaces.size()];
        i = 0;
        while (i < tmpSpaces.size()) {
            this.spaces[i] = (Serializable)tmpSpaces.get(i);
            ++i;
        }
    }

    public BulkOperationCleanupAction(SessionImplementor session, Set querySpaces) {
        this.session = session;
        HashSet<Serializable> tmpSpaces = new HashSet<Serializable>(querySpaces);
        SessionFactoryImplementor factory = session.getFactory();
        for (Map.Entry entry : factory.getAllClassMetadata().entrySet()) {
            Set roles;
            String entityName = (String)entry.getKey();
            EntityPersister persister = factory.getEntityPersister(entityName);
            Serializable[] entitySpaces = persister.getQuerySpaces();
            if (!this.affectedEntity(querySpaces, entitySpaces)) continue;
            if (persister.hasCache()) {
                this.affectedEntityNames.add(persister.getEntityName());
            }
            if ((roles = session.getFactory().getCollectionRolesByEntityParticipant(persister.getEntityName())) != null) {
                this.affectedCollectionRoles.addAll(roles);
            }
            int y = 0;
            while (y < entitySpaces.length) {
                tmpSpaces.add(entitySpaces[y]);
                ++y;
            }
        }
        this.spaces = tmpSpaces.toArray(new Serializable[tmpSpaces.size()]);
    }

    private boolean affectedEntity(Set querySpaces, Serializable[] entitySpaces) {
        if (querySpaces == null || querySpaces.isEmpty()) {
            return true;
        }
        int i = 0;
        while (i < entitySpaces.length) {
            if (querySpaces.contains(entitySpaces[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void init() {
        this.evictEntityRegions();
        this.evictCollectionRegions();
    }

    public boolean hasAfterTransactionCompletion() {
        return true;
    }

    public void afterTransactionCompletion(boolean success) throws HibernateException {
        if (this.session.getFactory().getSettings().getCacheProvider() instanceof OptimisticTreeCacheProvider || this.session.getFactory().getSettings().getCacheProvider() instanceof TreeCacheProvider) {
            return;
        }
        this.evictEntityRegions();
        this.evictCollectionRegions();
    }

    public Serializable[] getPropertySpaces() {
        return this.spaces;
    }

    public void beforeExecutions() throws HibernateException {
    }

    public void execute() throws HibernateException {
    }

    private void evictEntityRegions() {
        if (this.affectedEntityNames != null) {
            for (String entityName : this.affectedEntityNames) {
                this.session.getFactory().evictEntity(entityName);
            }
        }
    }

    private void evictCollectionRegions() {
        if (this.affectedCollectionRoles != null) {
            for (String roleName : this.affectedCollectionRoles) {
                this.session.getFactory().evictCollection(roleName);
            }
        }
    }
}

