/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class ScrollMode
implements Serializable {
    private final int resultSetType;
    private final String name;
    private static final Map INSTANCES = new HashMap();
    public static final ScrollMode FORWARD_ONLY = new ScrollMode(1003, "FORWARD_ONLY");
    public static final ScrollMode SCROLL_SENSITIVE = new ScrollMode(1005, "SCROLL_SENSITIVE");
    public static final ScrollMode SCROLL_INSENSITIVE = new ScrollMode(1004, "SCROLL_INSENSITIVE");

    static {
        INSTANCES.put(ScrollMode.FORWARD_ONLY.name, FORWARD_ONLY);
        INSTANCES.put(ScrollMode.SCROLL_INSENSITIVE.name, SCROLL_INSENSITIVE);
        INSTANCES.put(ScrollMode.SCROLL_SENSITIVE.name, SCROLL_SENSITIVE);
    }

    private ScrollMode(int level, String name) {
        this.resultSetType = level;
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public int toResultSetType() {
        return this.resultSetType;
    }

    public boolean lessThan(ScrollMode other) {
        return this.resultSetType < other.resultSetType;
    }

    private Object readResolve() {
        return INSTANCES.get(this.name);
    }
}

