/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class CacheMode
implements Serializable {
    private final String name;
    private final boolean isPutEnabled;
    private final boolean isGetEnabled;
    private static final Map INSTANCES = new HashMap();
    public static final CacheMode NORMAL = new CacheMode("NORMAL", true, true);
    public static final CacheMode IGNORE = new CacheMode("IGNORE", false, false);
    public static final CacheMode GET = new CacheMode("GET", false, true);
    public static final CacheMode PUT = new CacheMode("PUT", true, false);
    public static final CacheMode REFRESH = new CacheMode("REFRESH", true, false);

    static {
        INSTANCES.put(CacheMode.NORMAL.name, NORMAL);
        INSTANCES.put(CacheMode.IGNORE.name, IGNORE);
        INSTANCES.put(CacheMode.GET.name, GET);
        INSTANCES.put(CacheMode.PUT.name, PUT);
        INSTANCES.put(CacheMode.REFRESH.name, REFRESH);
    }

    private CacheMode(String name, boolean isPutEnabled, boolean isGetEnabled) {
        this.name = name;
        this.isPutEnabled = isPutEnabled;
        this.isGetEnabled = isGetEnabled;
    }

    public String toString() {
        return this.name;
    }

    public boolean isPutEnabled() {
        return this.isPutEnabled;
    }

    public boolean isGetEnabled() {
        return this.isGetEnabled;
    }

    private Object readResolve() {
        return INSTANCES.get(this.name);
    }

    public static CacheMode parse(String name) {
        return (CacheMode)INSTANCES.get(name);
    }
}

