/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.relations.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.platform.relations.api.Graph;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.jena.JenaGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IORelationGraphHelper {
    protected final Map<String, String> namespaces;
    protected List<Statement> statements;

    public IORelationGraphHelper(Map<String, String> namespaces, List<Statement> statements) {
        this.namespaces = namespaces;
        this.statements = statements;
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    protected Graph createMemoryGraph() {
        JenaGraph graph = new JenaGraph();
        graph.setNamespaces(this.namespaces);
        return graph;
    }

    public void write(OutputStream out) {
        Graph graph = this.createMemoryGraph();
        if (this.statements != null) {
            graph.add(this.statements);
        }
        graph.write(out, null, null);
    }

    public void read(InputStream in) {
        Graph graph = this.createMemoryGraph();
        if (this.statements != null) {
            graph.add(this.statements);
        }
        graph.read(in, null, null);
        this.statements = graph.getStatements();
    }

    public Graph getGraph() {
        Graph graph = this.createMemoryGraph();
        if (this.statements != null) {
            graph.add(this.statements);
        }
        return graph;
    }
}

