/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.protocols.pbcast.Digest;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Util;

public class DigestTest
extends TestCase {
    Digest d;
    Digest d2;
    IpAddress a1;
    IpAddress a2;
    IpAddress a3;

    public DigestTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.d = new Digest(3);
        this.a1 = new IpAddress(5555);
        this.a2 = new IpAddress(6666);
        this.a3 = new IpAddress(7777);
        this.d.add(this.a1, 4L, 500L, 501L);
        this.d.add(this.a2, 25L, 26L, 26L);
        this.d.add(this.a3, 20L, 25L, 33L);
    }

    public void testSize() {
        this.d2 = new Digest(3);
        DigestTest.assertEquals((int)this.d2.size(), (int)0);
    }

    public void testEquals() {
        this.d2 = this.d.copy();
        System.out.println("d: " + this.d + "\nd2= " + this.d2);
        DigestTest.assertEquals((Object)this.d, (Object)this.d);
        DigestTest.assertEquals((Object)this.d, (Object)this.d2);
        this.d2.incrementHighSeqno(this.a1);
        DigestTest.assertFalse((boolean)this.d.equals(this.d2));
    }

    public void testAdd() {
        DigestTest.assertEquals((int)this.d.size(), (int)3);
        this.d.add(this.a1, 100L, 200L, 201L);
        DigestTest.assertEquals((int)this.d.size(), (int)3);
        this.d.add(new IpAddress(14526), 1L, 2L, 3L);
        DigestTest.assertEquals((int)this.d.size(), (int)4);
    }

    public void testAddDigest() {
        this.d2 = this.d.copy();
        this.d.add(this.d2);
        DigestTest.assertEquals((int)this.d.size(), (int)3);
    }

    public void testAddDigest2() {
        this.d2 = new Digest(4);
        this.d2.add(new IpAddress(1111), 1L, 2L, 3L);
        this.d2.add(new IpAddress(2222), 1L, 2L, 3L);
        this.d2.add(new IpAddress(5555), 1L, 2L, 3L);
        this.d2.add(new IpAddress(6666), 1L, 2L, 3L);
        this.d.add(this.d2);
        DigestTest.assertEquals((int)this.d.size(), (int)5);
    }

    public void testGet() {
        Digest.Entry entry = this.d.get(this.a1);
        DigestTest.assertEquals((Object)entry, (Object)new Digest.Entry(4L, 500L, 501L));
        entry = this.d.get(this.a2);
        DigestTest.assertEquals((Object)entry, (Object)new Digest.Entry(25L, 26L, 26L));
        entry = this.d.get(this.a3);
        DigestTest.assertEquals((Object)entry, (Object)new Digest.Entry(20L, 25L, 33L));
    }

    public void testIncrementHighSeqno() {
        this.d2 = new Digest(3);
        this.d2.add(this.a1, 1L, 100L);
        this.d2.add(this.a2, 3L, 300L);
        this.d2.add(this.a3, 7L, 700L);
        long tmp = this.d2.highSeqnoAt(this.a1);
        this.d2.incrementHighSeqno(this.a1);
        DigestTest.assertEquals((long)this.d2.highSeqnoAt(this.a1), (long)(tmp + 1L));
        tmp = this.d2.highSeqnoAt(this.a2);
        this.d2.incrementHighSeqno(this.a2);
        DigestTest.assertEquals((long)this.d2.highSeqnoAt(this.a2), (long)(tmp + 1L));
        tmp = this.d2.highSeqnoAt(this.a3);
        this.d2.incrementHighSeqno(this.a3);
        DigestTest.assertEquals((long)this.d2.highSeqnoAt(this.a3), (long)(tmp + 1L));
    }

    public void testConstructor() {
        DigestTest.assertTrue((this.d.size() == 3 ? 1 : 0) != 0);
        this.d.clear();
        DigestTest.assertTrue((this.d.size() == 0 ? 1 : 0) != 0);
        this.d.clear();
        DigestTest.assertTrue((this.d.size() == 0 ? 1 : 0) != 0);
    }

    public void testConstructor2() {
        Digest dd = new Digest(3);
        DigestTest.assertEquals((int)dd.size(), (int)0);
    }

    public void testContains() {
        DigestTest.assertTrue((boolean)this.d.contains(this.a1));
        DigestTest.assertTrue((boolean)this.d.contains(this.a2));
        DigestTest.assertTrue((boolean)this.d.contains(this.a3));
    }

    public void testResetAt() {
        this.d.resetAt(this.a1);
        DigestTest.assertTrue((this.d.lowSeqnoAt(this.a1) == 0L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.highSeqnoAt(this.a1) == 0L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.highSeqnoSeenAt(this.a1) == -1L ? 1 : 0) != 0);
    }

    public void testLowSeqnoAt() {
        DigestTest.assertTrue((this.d.lowSeqnoAt(this.a1) == 4L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.lowSeqnoAt(this.a2) == 25L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.lowSeqnoAt(this.a3) == 20L ? 1 : 0) != 0);
    }

    public void testHighSeqnoAt() {
        DigestTest.assertTrue((this.d.highSeqnoAt(this.a1) == 500L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.highSeqnoAt(this.a2) == 26L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.highSeqnoAt(this.a3) == 25L ? 1 : 0) != 0);
    }

    public void testHighSeqnoSeenAt() {
        DigestTest.assertTrue((this.d.highSeqnoSeenAt(this.a1) == 501L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.highSeqnoSeenAt(this.a2) == 26L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.highSeqnoSeenAt(this.a3) == 33L ? 1 : 0) != 0);
    }

    public void testCopy() {
        this.d = this.d.copy();
        this.testLowSeqnoAt();
        this.testHighSeqnoAt();
        this.testHighSeqnoSeenAt();
        this.testContains();
        this.testResetAt();
    }

    public void testNonConflictingMerge() {
        Digest cons_d = new Digest(5);
        IpAddress ip1 = new IpAddress(1111);
        IpAddress ip2 = new IpAddress(2222);
        cons_d.add(ip1, 1L, 10L, 10L);
        cons_d.add(ip2, 2L, 20L, 20L);
        cons_d.merge(this.d);
        DigestTest.assertEquals((int)cons_d.size(), (int)5);
        DigestTest.assertTrue((cons_d.lowSeqnoAt(ip1) == 1L ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.lowSeqnoAt(ip2) == 2L ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.lowSeqnoAt(this.a1) == 4L ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.lowSeqnoAt(this.a2) == 25L ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.lowSeqnoAt(this.a3) == 20L ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.highSeqnoAt(ip1) == 10L ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.highSeqnoAt(ip2) == 20L ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.highSeqnoAt(this.a1) == 500L ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.highSeqnoAt(this.a2) == 26L ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.highSeqnoAt(this.a3) == 25L ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.highSeqnoSeenAt(ip1) == 10L ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.highSeqnoSeenAt(ip2) == 20L ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.highSeqnoSeenAt(this.a1) == 501L ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.highSeqnoSeenAt(this.a2) == 26L ? 1 : 0) != 0);
        DigestTest.assertTrue((cons_d.highSeqnoSeenAt(this.a3) == 33L ? 1 : 0) != 0);
    }

    public void testConflictingMerge() {
        Digest new_d = new Digest(2);
        new_d.add(this.a1, 5L, 450L, 501L);
        new_d.add(this.a3, 18L, 28L, 35L);
        this.d.merge(new_d);
        DigestTest.assertEquals((int)this.d.size(), (int)3);
        DigestTest.assertTrue((this.d.lowSeqnoAt(this.a1) == 4L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.highSeqnoAt(this.a1) == 500L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.highSeqnoSeenAt(this.a1) == 501L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.lowSeqnoAt(this.a2) == 25L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.highSeqnoAt(this.a2) == 26L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.highSeqnoSeenAt(this.a2) == 26L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.lowSeqnoAt(this.a3) == 18L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.highSeqnoAt(this.a3) == 28L ? 1 : 0) != 0);
        DigestTest.assertTrue((this.d.highSeqnoSeenAt(this.a3) == 35L ? 1 : 0) != 0);
    }

    public void testSameSendersOtherIsNull() {
        DigestTest.assertFalse((boolean)this.d.sameSenders(null));
    }

    public void testSameSenders1MNullDifferentLenth() {
        this.d2 = new Digest(1);
        DigestTest.assertFalse((boolean)this.d2.sameSenders(this.d));
    }

    public void testSameSenders1MNullSameLength() {
        this.d2 = new Digest(3);
        DigestTest.assertFalse((boolean)this.d2.sameSenders(this.d));
    }

    public void testSameSendersIdentical() {
        this.d2 = this.d.copy();
        DigestTest.assertTrue((boolean)this.d.sameSenders(this.d2));
    }

    public void testSameSendersNotIdentical() {
        this.d2 = new Digest(3);
        this.d2.add(this.a1, 4L, 500L, 501L);
        this.d2.add(this.a3, 20L, 25L, 33L);
        this.d2.add(this.a2, 25L, 26L, 26L);
        DigestTest.assertTrue((boolean)this.d.sameSenders(this.d2));
    }

    public void testSameSendersNotSameLength() {
        this.d2 = new Digest(3);
        this.d2.add(this.a1, 4L, 500L, 501L);
        this.d2.add(this.a2, 25L, 26L, 26L);
        DigestTest.assertFalse((boolean)this.d.sameSenders(this.d2));
    }

    public void testStreamable() throws IOException, IllegalAccessException, InstantiationException {
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(outstream);
        this.d.writeTo(dos);
        dos.close();
        byte[] buf = outstream.toByteArray();
        ByteArrayInputStream instream = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(instream);
        Digest tmp = new Digest();
        tmp.readFrom(dis);
        DigestTest.assertEquals((Object)this.d, (Object)tmp);
    }

    public void testSerializedSize() throws Exception {
        long len = this.d.serializedSize();
        byte[] buf = Util.streamableToByteBuffer(this.d);
        DigestTest.assertEquals((long)len, (long)buf.length);
    }

    public static Test suite() {
        TestSuite s = new TestSuite(DigestTest.class);
        return s;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)DigestTest.suite());
    }
}

