/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.awt.Frame;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JButton;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.util.Util;

public class Chat
implements MouseListener,
WindowListener,
MessageListener,
MembershipListener {
    Channel channel;
    PullPushAdapter ad;
    Thread mainThread;
    final String group_name = "ChatGroup";
    String props = null;
    Frame mainFrame;
    TextArea ta;
    TextField tf;
    Label csLabel;
    JButton leaveButton;
    JButton sendButton;
    JButton clearButton;
    String username = null;
    LinkedList history = new LinkedList();

    public Chat(String props) {
        this.props = props;
        try {
            this.username = System.getProperty("user.name");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        String props = null;
        for (int i = 0; i < args.length; ++i) {
            if (!"-props".equals(args[i])) {
                Chat.help();
                return;
            }
            props = args[++i];
        }
        Chat chat = new Chat(props);
        chat.start();
    }

    static void help() {
        System.out.println("Chat [-help] [-props <properties>]");
    }

    public void start() {
        this.mainFrame = new Frame();
        this.mainFrame.setLayout(null);
        this.mainFrame.setSize(600, 507);
        this.mainFrame.addWindowListener(this);
        this.ta = new TextArea();
        this.ta.setBounds(12, 36, 550, 348);
        this.ta.setEditable(false);
        this.mainFrame.add(this.ta);
        this.tf = new TextField();
        this.tf.setBounds(100, 392, 400, 30);
        this.mainFrame.add(this.tf);
        this.csLabel = new Label("Send:");
        this.csLabel.setBounds(12, 392, 85, 30);
        this.mainFrame.add(this.csLabel);
        this.leaveButton = new JButton("Leave");
        this.leaveButton.setBounds(12, 428, 150, 30);
        this.leaveButton.addMouseListener(this);
        this.mainFrame.add(this.leaveButton);
        this.sendButton = new JButton("Send");
        this.sendButton.setBounds(182, 428, 150, 30);
        this.sendButton.addMouseListener(this);
        this.mainFrame.add(this.sendButton);
        this.clearButton = new JButton("Clear");
        this.clearButton.setBounds(340, 428, 150, 30);
        this.clearButton.addMouseListener(this);
        this.mainFrame.add(this.clearButton);
        try {
            this.channel = new JChannel(this.props);
            this.channel.setOpt(5, Boolean.TRUE);
            this.channel.setOpt(6, Boolean.TRUE);
            this.channel.setOpt(4, Boolean.TRUE);
            System.out.println("Connecting to ChatGroup");
            this.channel.connect("ChatGroup");
            this.ad = new PullPushAdapter(this.channel, this, this);
            this.channel.getState(null, 5000L);
        }
        catch (Exception e) {
            this.ta.append(e.toString());
        }
        this.mainFrame.pack();
        this.mainFrame.setLocation(15, 25);
        this.mainFrame.setBounds(new Rectangle(580, 480));
        this.mainFrame.setVisible(true);
        this.mainFrame.show();
        if (this.history.size() > 0) {
            Iterator it = this.history.iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                this.ta.append(s + "\n");
            }
        }
    }

    public void receive(Message msg) {
        try {
            Object o = msg.getObject();
            this.ta.append(o + " [" + msg.getSrc() + "]\n");
            this.history.add(o);
        }
        catch (Exception e) {
            this.ta.append("Chat.receive(): " + e);
        }
    }

    public byte[] getState() {
        try {
            return Util.objectToByteBuffer(this.history);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setState(byte[] state) {
        try {
            this.history = (LinkedList)Util.objectFromByteBuffer(state);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void viewAccepted(View new_view) {
        this.ta.append("Received view " + new_view + '\n');
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    private synchronized void handleLeave() {
        try {
            System.out.print("Stopping PullPushAdapter");
            this.ad.stop();
            System.out.println(" -- done");
            System.out.print("Disconnecting the channel");
            this.channel.disconnect();
            System.out.println(" -- done");
            System.out.print("Closing the channel");
            this.channel.close();
            System.out.println(" -- done");
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.ta.append("Failed leaving the group: " + e.toString() + '\n');
        }
    }

    private void handleSend() {
        try {
            Message msg = new Message(null, null, (Serializable)((Object)(this.username + ": " + this.tf.getText())));
            this.channel.send(msg);
        }
        catch (Exception e) {
            this.ta.append("Failed sending message: " + e.toString() + '\n');
        }
    }

    public void mouseClicked(MouseEvent e) {
        Object obj = e.getSource();
        if (obj == this.leaveButton) {
            this.handleLeave();
        } else if (obj == this.sendButton) {
            this.handleSend();
        } else if (obj == this.clearButton) {
            this.ta.setText("");
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        System.exit(0);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

