/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.ws;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.ecm.platform.audit.ws.BatchInfo;

public class BatchHelper {
    private static final Map<String, BatchInfo> pageInfo = new ConcurrentHashMap<String, BatchInfo>();

    private BatchHelper() {
    }

    public static BatchInfo getBatchInfo(String sessionId, String dateRange) {
        BatchInfo bInfo = pageInfo.get(sessionId);
        if (bInfo != null && bInfo.getPageDateRange().equals(dateRange)) {
            return bInfo;
        }
        pageInfo.put(sessionId, new BatchInfo(dateRange));
        return pageInfo.get(sessionId);
    }

    public static void resetBatchInfo(String sessionId) {
        if (pageInfo.containsKey(sessionId)) {
            pageInfo.remove(sessionId);
        }
    }
}

