/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.themes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.theme.themes.ThemeSetEntry;
import org.nuxeo.theme.types.Type;
import org.nuxeo.theme.types.TypeFamily;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XObject(value="themeset")
public class ThemeSet
implements Type {
    @XNode(value="@name")
    public String name;
    @XNodeMap(value="theme", key="@name", type=HashMap.class, componentType=ThemeSetEntry.class)
    public Map<String, ThemeSetEntry> themes;

    @Override
    public TypeFamily getTypeFamily() {
        return TypeFamily.THEMESET;
    }

    @Override
    public String getTypeName() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setTheme(ThemeSetEntry theme) {
        this.themes.put(theme.getName(), theme);
    }

    public ThemeSetEntry getTheme(String themeName) {
        return this.themes.get(themeName);
    }

    public List<ThemeSetEntry> getThemes() {
        return new ArrayList<ThemeSetEntry>(this.themes.values());
    }

    public String getThemeForFeature(String feature) {
        for (ThemeSetEntry theme : this.getThemes()) {
            if (!theme.getFeatures().contains(feature)) continue;
            return theme.getName();
        }
        return null;
    }

    public void addFeatureToTheme(String themeName, String feature) {
        for (ThemeSetEntry theme : this.getThemes()) {
            if (theme.getName().equals(themeName)) {
                theme.addFeature(feature);
                continue;
            }
            theme.removeFeature(feature);
        }
    }
}

