/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.rendering;

import java.net.URL;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.elements.Element;
import org.nuxeo.theme.elements.ThemeElement;
import org.nuxeo.theme.engines.EngineType;
import org.nuxeo.theme.formats.Format;
import org.nuxeo.theme.models.Info;
import org.nuxeo.theme.models.Model;
import org.nuxeo.theme.templates.TemplateEngineType;
import org.nuxeo.theme.themes.ThemeManager;
import org.nuxeo.theme.uids.Identifiable;

public class RenderingInfo
implements Info,
Identifiable {
    private String markup = "";
    private Model model;
    private Element element;
    private Format format;
    private Integer uid;
    private String name;
    private URL themeUrl;
    private boolean dirty = false;

    public RenderingInfo() {
    }

    public RenderingInfo(Element element, URL themeUrl) {
        this.element = element;
        this.themeUrl = themeUrl;
        this.uid = element.getUid();
    }

    public RenderingInfo createCopy() {
        RenderingInfo clone = new RenderingInfo(this.element, this.themeUrl);
        clone.setDirty(this.dirty);
        return clone;
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public String getMarkup() {
        return this.markup;
    }

    public void setMarkup(String markup) {
        this.markup = markup;
    }

    public Integer getUid() {
        return this.uid;
    }

    public void setUid(Integer uid) {
        this.uid = uid;
    }

    public EngineType getEngine() {
        return ThemeManager.getEngineByUrl(this.themeUrl);
    }

    public String getViewMode() {
        return ThemeManager.getViewModeByUrl(this.themeUrl);
    }

    public URL getThemeUrl() {
        return this.themeUrl;
    }

    public Element getElement() {
        return this.element;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public Format getFormat() {
        return this.format;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ThemeElement getTheme() {
        return Manager.getThemeManager().getThemeByUrl(this.themeUrl);
    }

    public TemplateEngineType getTemplateEngine() {
        return ThemeManager.getTemplateEngineByUrl(this.themeUrl);
    }

    public boolean isRenderingPostponed(boolean cache) {
        return cache && this.isDirty();
    }
}

