/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.presets;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.theme.presets.PaletteParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GimpPaletteParser
extends PaletteParser {
    static final Pattern colorPattern = Pattern.compile("^\\s*(\\d{1,3})\\s+(\\d{1,3})\\s+(\\d{1,3})\\t{0,1}(.*)$", 8);

    public static boolean checkSanity(byte[] bytes) {
        return new String(bytes).startsWith("GIMP Palette");
    }

    public static Map<String, String> parse(byte[] bytes) {
        LinkedHashMap<String, String> entries = new LinkedHashMap<String, String>();
        Matcher matcher = colorPattern.matcher(new String(bytes));
        int counter = 1;
        while (matcher.find()) {
            String key = matcher.group(4).trim();
            int r = Integer.parseInt(matcher.group(1));
            int g = Integer.parseInt(matcher.group(2));
            int b = Integer.parseInt(matcher.group(3));
            String value = GimpPaletteParser.rgbToHex(r, g, b);
            if (key.equals("Untitled")) {
                key = String.format("Color %s", counter);
            }
            entries.put(key, value);
            ++counter;
        }
        return entries;
    }
}

