/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.models;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.theme.models.Info;
import org.nuxeo.theme.rendering.RenderingInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InfoPool {
    private static final String INFOID_PREFIX = "i";
    protected static final ThreadLocal<HashMap<String, Info>> threadInstance = new ThreadLocal<HashMap<String, Info>>(){

        @Override
        protected HashMap<String, Info> initialValue() {
            return new HashMap<String, Info>();
        }
    };

    public static Map<String, Info> getInfoMap() {
        return threadInstance.get();
    }

    public static void register(RenderingInfo info) {
        InfoPool.getInfoMap().put(InfoPool.computeInfoId(info), info);
    }

    public static Info get(String key) {
        return InfoPool.getInfoMap().get(key);
    }

    public static String computeInfoId(RenderingInfo info) {
        return INFOID_PREFIX + info.getUid().toString();
    }
}

