/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.formats;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.formats.FormatFilter;
import org.nuxeo.theme.formats.FormatType;
import org.nuxeo.theme.rendering.Filter;
import org.nuxeo.theme.rendering.FilterType;
import org.nuxeo.theme.rendering.FilterTypeFamily;
import org.nuxeo.theme.types.TypeFamily;

@XObject(value="format-filter")
public final class FormatFilterType
extends FilterType {
    @XNode(value="@name")
    public String name;
    @XNode(value="engine")
    public String engine = "*";
    @XNode(value="template-engine")
    public String templateEngine = "*";
    @XNode(value="mode")
    public String mode = "*";
    @XNode(value="format-type")
    public String formatName;
    private final Map<String, Filter> filters = new HashMap<String, Filter>();

    public FormatFilterType() {
    }

    public FormatFilterType(String name, String formatName) {
        this.formatName = formatName;
    }

    public Filter getFilter() {
        if (this.filters.containsKey(this.formatName)) {
            return this.filters.get(this.formatName);
        }
        FormatType formatType = (FormatType)Manager.getTypeRegistry().lookup(TypeFamily.FORMAT, this.formatName);
        FormatFilter filter = new FormatFilter();
        filter.setFormatType(formatType);
        this.filters.put(this.formatName, filter);
        return filter;
    }

    public FilterTypeFamily getFilterTypeFamily() {
        return FilterTypeFamily.FORMAT;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public void setFormatName(String formatName) {
        this.formatName = formatName;
    }

    public String getTypeName() {
        return String.format("%s/%s/%s/%s", this.engine, this.templateEngine, this.mode, this.name);
    }

    public String getClassName() {
        return FormatFilter.class.getName();
    }
}

