/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.theme.negotiation;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import org.nuxeo.ecm.platform.ec.placeful.Annotation;

@Entity
public class LocalThemeConfig
extends Annotation {
    public static final String LOCAL_THEME_NAME = "LocalThemeConfig";
    private static final long serialVersionUID = 1L;
    private int localThemeId;
    private String theme;
    private String page;
    private String perspective;
    private String engine;
    private String mode;
    private String docId;

    public LocalThemeConfig() {
        this(null, null, null, null, null, null);
    }

    public LocalThemeConfig(String theme, String page, String perspective, String engine, String mode, String docId) {
        this.theme = theme;
        this.page = page;
        this.perspective = perspective;
        this.engine = engine;
        this.mode = mode;
        this.docId = docId;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    public int getId() {
        return this.localThemeId;
    }

    public void setId(int id) {
        this.localThemeId = id;
    }

    public String computePagePath() {
        if (this.theme == null || this.page == null) {
            return null;
        }
        return String.format("%s/%s", this.theme, this.page);
    }

    public String getDocId() {
        return this.docId;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    public String getPage() {
        return this.page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    @Column(name="themode")
    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getPerspective() {
        return this.perspective;
    }

    public void setPerspective(String perspective) {
        this.perspective = perspective;
    }
}

