/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.header;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.shell.header.CommandArgument;
import org.nuxeo.ecm.shell.header.CommandOption;

public class CommandPattern {
    public String[] names;
    public final List<CommandOption> options = new ArrayList<CommandOption>();
    public final List<CommandArgument> args = new ArrayList<CommandArgument>();

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(StringUtils.join((Object[])this.names, (char)'|')).append(" ");
        for (CommandOption opt : this.options) {
            buf.append(opt.toString()).append(" ");
        }
        for (CommandArgument arg : this.args) {
            buf.append(arg.toString()).append(" ");
        }
        return buf.toString();
    }

    public static CommandPattern parsePattern(String input) throws ParseException {
        CommandPattern cmd = new CommandPattern();
        int len = input.length();
        StringBuilder buf = new StringBuilder();
        CommandOption opt = null;
        CommandArgument arg = null;
        block5: for (int i = 0; i < len; ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\t': 
                case ' ': {
                    continue block5;
                }
                case '[': {
                    buf.setLength(0);
                    i = CommandPattern.collectUntil(']', buf, input, i + 1);
                    if (i >= len) {
                        throw new ParseException("no matching ']' found", i);
                    }
                    if (buf.length() == 0) {
                        throw new ParseException("Emtpy options [] found", i);
                    }
                    if (buf.charAt(0) == '-') {
                        opt = CommandPattern.parseOption(buf.toString());
                        opt.isRequired = false;
                        cmd.options.add(opt);
                        break;
                    }
                    arg = new CommandArgument();
                    arg.isOptional = true;
                    CommandPattern.initCommandArgument(arg, buf.toString());
                    cmd.args.add(arg);
                    break;
                }
                case '-': {
                    i = CommandPattern.collectUntil(' ', buf, input, i);
                    opt = CommandPattern.parseOption(buf.toString());
                    opt.isRequired = true;
                    cmd.options.add(opt);
                    break;
                }
                default: {
                    i = CommandPattern.collectUntil(' ', buf, input, i);
                    if (cmd.names == null) {
                        String names = buf.toString();
                        cmd.names = StringUtils.split((String)names, (char)'|', (boolean)false);
                        break;
                    }
                    arg = new CommandArgument();
                    CommandPattern.initCommandArgument(arg, buf.toString());
                    cmd.args.add(arg);
                }
            }
            buf.setLength(0);
        }
        return cmd;
    }

    private static void initCommandArgument(CommandArgument arg, String value) {
        int p = value.indexOf(58);
        if (p > 0) {
            arg.type = value.substring(p + 1);
            arg.name = value.substring(0, p);
        } else {
            arg.type = "string";
            arg.name = value;
        }
    }

    public static int collectUntil(char sep, StringBuilder buf, String input, int offset) {
        int len = input.length();
        for (int i = offset; i < len; ++i) {
            char c = input.charAt(i);
            if (c == sep) {
                return i;
            }
            buf.append(c);
        }
        return len;
    }

    private static CommandOption parseOption(String input) {
        CommandOption opt = new CommandOption();
        int p = input.indexOf(58);
        if (p > -1) {
            opt.names = StringUtils.split((String)input.substring(0, p), (char)'|', (boolean)true);
            opt.type = input.substring(p + 1);
            p = opt.type.indexOf(63);
            if (p > -1) {
                opt.defaultValue = opt.type.substring(p + 1);
                opt.type = opt.type.substring(0, p);
            }
        } else {
            opt.names = StringUtils.split((String)input, (char)'|', (boolean)true);
        }
        return opt;
    }

    public static void main(String[] args) throws Exception {
        String input = "cp|copy [--recurse|-r] [--depth|-d:int?1] [--version|-v] file [destination:doc]";
        System.out.println(input);
        CommandPattern cmd = CommandPattern.parsePattern(input);
        System.out.println(cmd);
        input = "cp|copy [--recurse|-r] [--depth|-d:int?1] [--version|-v] file [destination]";
        System.out.println(input);
        cmd = CommandPattern.parsePattern(input);
        System.out.println(cmd);
    }
}

