/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.commands.system;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.TypeService;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.shell.CommandLine;
import org.nuxeo.ecm.shell.commands.repository.AbstractCommand;
import org.nuxeo.ecm.shell.commands.system.util;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.ExtensionPoint;
import org.nuxeo.runtime.model.RegistrationInfo;

public class ServiceInfoCommand
extends AbstractCommand {
    private static final Log log = LogFactory.getLog(ServiceInfoCommand.class);

    public void run(CommandLine cmdLine) throws Exception {
        String[] elements = cmdLine.getParameters();
        if (elements.length > 1) {
            log.error((Object)(cmdLine.getCommand() + " takes zero or one parameter: the component name"));
        }
        RuntimeService runtime = Framework.getRuntime();
        ComponentManager cm = runtime.getComponentManager();
        if (elements.length == 0) {
            List<RegistrationInfo> ris = util.listRegistrationInfos();
            for (RegistrationInfo ri : ris) {
                log.info((Object)ServiceInfoCommand.show(ri, 0));
                log.info((Object)"-------------------------------------");
            }
        } else {
            String name = elements[0];
            RegistrationInfo ri = cm.getRegistrationInfo(new ComponentName(name));
            log.info((Object)ServiceInfoCommand.show(ri, 1));
        }
    }

    public static String show(RegistrationInfo ri, int verbosity) {
        ExtensionPoint[] extensionPoints;
        String[] propertyNames;
        RuntimeService runtime = Framework.getRuntime();
        ComponentManager cm = runtime.getComponentManager();
        ComponentInstance component = ri.getComponent();
        Object instance = component.getInstance();
        StringBuilder sb = new StringBuilder();
        sb.append("Component Name: ").append(component.getName()).append("\n");
        sb.append("Impl. Class Name: ").append(instance.getClass().getName()).append("\n");
        sb.append("\n");
        String[] serviceNames = component.getProvidedServiceNames();
        if (serviceNames.length > 0) {
            sb.append("Provides:\n");
            for (String serviceName : serviceNames) {
                sb.append("- ").append(serviceName).append("\n");
            }
            sb.append("\n");
        }
        if ((propertyNames = component.getPropertyNames()).length > 0) {
            sb.append("Properties:\n");
            for (String propertyName : propertyNames) {
                sb.append("- ").append(propertyName).append(" : ").append(component.getProperty(propertyName).getValue()).append("\n");
            }
            sb.append("\n");
        }
        if ((extensionPoints = ri.getExtensionPoints()).length > 0) {
            sb.append("Extension Points:\n");
            for (ExtensionPoint xp : extensionPoints) {
                sb.append("- ").append(xp.getName()).append("\n");
            }
            sb.append("\n");
        }
        if (verbosity > 0) {
            sb.append("documentation:\n");
            sb.append(ri.getDocumentation());
        }
        if (instance instanceof TypeService) {
            sb.append(ServiceInfoCommand.detail((TypeService)instance));
        }
        return sb.toString();
    }

    public static String detail(TypeService instance) {
        Type[] types;
        Schema[] schemas;
        StringBuilder sb = new StringBuilder();
        SchemaManager sm = instance.getTypeManager();
        DocumentType[] doctypes = sm.getDocumentTypes();
        if (doctypes.length > 0) {
            sb.append("Document Types:\n");
            for (DocumentType doctype : doctypes) {
                Set facets;
                sb.append("- ").append(doctype.getName()).append("\n");
                Collection schemas2 = doctype.getSchemas();
                if (schemas2.size() > 0) {
                    sb.append("  Schemas: ");
                    for (Schema schema : schemas2) {
                        if (schema != null) {
                            sb.append(schema.getName()).append(" ");
                            continue;
                        }
                        sb.append("(null)").append(" ");
                    }
                    sb.append("\n");
                }
                if ((facets = doctype.getFacets()).size() <= 0) continue;
                sb.append("  Facets: ");
                for (String facet : facets) {
                    sb.append(facet).append(" ");
                }
                sb.append("\n");
            }
            sb.append("\n");
        }
        if ((schemas = sm.getSchemas()).length > 0) {
            sb.append("Schemas:\n");
            for (Schema schema : schemas) {
                sb.append("- ").append(schema.getName()).append("\n");
            }
            sb.append("\n");
        }
        if ((types = sm.getTypes()).length > 0) {
            sb.append("Types:\n");
            for (Type type : types) {
                sb.append("- ").append(type.getName()).append("\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

