/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.commands.repository;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.repository.RepositoryInstance;
import org.nuxeo.ecm.shell.CommandLine;
import org.nuxeo.ecm.shell.commands.ColorHelper;
import org.nuxeo.ecm.shell.commands.repository.AbstractCommand;

public class TreeCommand
extends AbstractCommand {
    private static final Log log = LogFactory.getLog(TreeCommand.class);
    private int size = 0;

    public void run(CommandLine cmdLine) throws Exception {
        long t0 = System.currentTimeMillis();
        this.getTreeList(null);
        log.info((Object)("\n" + this.getSize() + " docs listed in " + (System.currentTimeMillis() - t0) + "ms\n"));
    }

    public int getTreeList(DocumentRef ref) throws Exception {
        RepositoryInstance repo = this.context.getRepositoryInstance();
        DocumentRef docRef = this.context.getCurrentDocument();
        if (ref != null && !ref.equals(docRef)) {
            docRef = ref;
        }
        DocumentModelList docs = repo.getChildren(docRef);
        for (DocumentModel doc : docs) {
            boolean isFolder = doc.isFolder();
            String docType = doc.getType();
            if (isFolder && docType.equals("Domain")) {
                log.info((Object)ColorHelper.decorateName(doc, "+ " + doc.getName()));
                log.info((Object)ColorHelper.decorateName(doc, "|"));
                this.getTreeList(doc.getRef());
                continue;
            }
            if (isFolder && (docType.equals("TemplateRoot") || docType.equals("SectionRoot") || docType.equals("WorkspaceRoot"))) {
                log.info((Object)ColorHelper.decorateName(doc, "| |-+ " + doc.getName()));
                log.info((Object)ColorHelper.decorateName(doc, "| | |"));
                this.getTreeList(doc.getRef());
                continue;
            }
            if (isFolder && (docType.equals("Workspace") || docType.equals("Section") || docType.equals("Template"))) {
                log.info((Object)ColorHelper.decorateName(doc, "| | |-+ " + doc.getName()));
                log.info((Object)ColorHelper.decorateName(doc, "| | | |"));
                this.getTreeList(doc.getRef());
                continue;
            }
            log.info((Object)(ColorHelper.decorateBranchesInBlue("| | | |") + ColorHelper.decorateName(doc, "- " + doc.getName())));
        }
        this.setSize(this.size + docs.size());
        return this.size;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }
}

