/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.commands.repository;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.repository.RepositoryInstance;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.shell.CommandLine;
import org.nuxeo.ecm.shell.commands.repository.AbstractCommand;

public class AddLocalAceCommand
extends AbstractCommand {
    public static final Log log = LogFactory.getLog(AddLocalAceCommand.class);

    public void run(CommandLine cmdLine) throws Exception {
        String[] parameters = cmdLine.getParameters();
        DocumentModel doc = this.context.fetchDocument();
        if (parameters.length != 3) {
            log.error((Object)(cmdLine.getCommand() + " takes exactly 3 parameters: the username, the permission and a boolean (grant if true, deny if false)"));
            return;
        }
        String user = parameters[0];
        String permission = parameters[1];
        boolean grant = new Boolean(parameters[2]);
        RepositoryInstance session = this.context.getCoreSession();
        this.addLocalAce((CoreSession)session, doc, user, permission, grant);
        session.save();
    }

    protected void addLocalAce(CoreSession session, DocumentModel doc, String user, String permission, boolean grant) throws Exception {
        ACP acp = session.getACP(doc.getRef());
        ACL acl = acp.getACL("local");
        if (acl == null) {
            acl = new ACLImpl("local");
            acp.addACL(acl);
        }
        acl.add(0, (Object)new ACE(user, permission, grant));
        session.setACP(doc.getRef(), acp, true);
    }
}

