/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.commands;

import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jline.ArgumentCompletor;
import jline.Completor;
import jline.ConsoleReader;
import jline.CursorBuffer;
import jline.FileNameCompletor;
import org.nuxeo.ecm.shell.CommandDescriptor;
import org.nuxeo.ecm.shell.CommandLine;
import org.nuxeo.ecm.shell.CommandLineService;
import org.nuxeo.ecm.shell.CommandOption;
import org.nuxeo.ecm.shell.CommandParameter;
import org.nuxeo.ecm.shell.Token;
import org.nuxeo.ecm.shell.commands.CommandCompletor;
import org.nuxeo.ecm.shell.commands.DocumentNameCompletor;
import org.nuxeo.ecm.shell.commands.InteractiveCommand;

public class CompositeCompletor
implements Completor {
    private final InteractiveCommand cmd;
    private final CommandCompletor completor;
    private final CommandLineService service;
    private final ConsoleReader console;
    final Map<String, Completor> completors = new HashMap<String, Completor>();

    public CompositeCompletor(InteractiveCommand cmd) {
        this.cmd = cmd;
        this.service = cmd.getService();
        this.console = cmd.getConsole();
        this.completor = new CommandCompletor(this.service);
        this.completors.put("cmd", (Completor)this.completor);
        this.completors.put("file", (Completor)new FileNameCompletor());
        this.completors.put("doc", new DocumentNameCompletor(this.service));
    }

    public void setCompletor(String name, Completor completor) {
        this.completors.put(name, completor);
    }

    public void removeCompletor(String name) {
        this.completors.remove(name);
    }

    public int complete(String buffer, int cursor, List candidates) {
        CommandLine cmdLine;
        String text;
        CursorBuffer buf = this.console.getCursorBuffer();
        ArgumentCompletor.ArgumentList list = new ArgumentCompletor.WhitespaceArgumentDelimiter().delimit(buffer, cursor);
        String[] args = list.getArguments();
        String argText = list.getCursorArgument();
        int argIndex = list.getCursorArgumentIndex();
        int offset = list.getArgumentPosition();
        String string = text = argText == null ? null : argText.substring(0, offset);
        if (argIndex == 0) {
            int ret = this.completor.complete(text, offset, candidates);
            return ret + (list.getBufferPosition() - offset);
        }
        CommandDescriptor cd = this.service.getCommand(args[0]);
        if (cd == null) {
            return -1;
        }
        if (buffer.endsWith(" ")) {
            String[] newArgs = new String[args.length + 1];
            System.arraycopy(args, 0, newArgs, 0, args.length);
            newArgs[args.length] = "";
            args = newArgs;
        }
        try {
            cmdLine = this.service.parse(args, false);
        }
        catch (ParseException e) {
            return -1;
        }
        if (argIndex >= cmdLine.size()) {
            return -1;
        }
        Token token = (Token)cmdLine.get(argIndex);
        if (token == null) {
            return -1;
        }
        if (token.type == 1) {
            return -1;
        }
        if (token.type == 2) {
            if (!cd.hasOptions()) {
                return -1;
            }
            Token optToken = (Token)cmdLine.get(token.info);
            CommandOption opt = this.service.getCommandOption(optToken.value);
            if (opt == null) {
                return -1;
            }
            String type = opt.getType();
            if (type == null || type.length() == 0) {
                return -1;
            }
            Completor comp = this.completors.get(type);
            if (comp != null) {
                int ret = comp.complete(text, offset, candidates);
                return ret + (list.getBufferPosition() - offset);
            }
        } else if (token.type == 3) {
            if (!cd.hasArguments()) {
                return -1;
            }
            for (CommandParameter param : cd.getArguments()) {
                if (token.info != param.index) continue;
                if (param.type == null || param.type.length() == 0) {
                    return -1;
                }
                Completor comp = this.completors.get(param.type);
                if (comp == null) continue;
                int ret = comp.complete(text, offset, candidates);
                return ret + (list.getBufferPosition() - offset);
            }
        }
        return -1;
    }
}

