/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell;

import java.text.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.repository.RepositoryInstance;
import org.nuxeo.ecm.core.client.NuxeoClient;
import org.nuxeo.ecm.shell.CommandContext;
import org.nuxeo.ecm.shell.CommandDescriptor;
import org.nuxeo.ecm.shell.CommandLine;
import org.nuxeo.ecm.shell.CommandLineService;
import org.nuxeo.ecm.shell.IPHelper;
import org.nuxeo.ecm.shell.commands.system.LogCommand;
import org.nuxeo.runtime.api.Framework;

public class Main {
    private static final Log log = LogFactory.getLog(Main.class);

    private Main() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int rcmds;
        CommandDescriptor cd;
        boolean debugMode;
        CommandLine cmdLine;
        CommandLineService service = (CommandLineService)((Object)Framework.getRuntime().getService(CommandLineService.class));
        try {
            cmdLine = service.parse(args, true);
        }
        catch (ParseException e) {
            log.error((Object)e);
            return;
        }
        String cmdName = cmdLine.getCommand();
        if (cmdName == null) {
            cmdName = "interactive";
            cmdLine.addCommand(cmdName);
        }
        CommandContext cmdContext = service.getCommandContext();
        cmdContext.setCommandLine(cmdLine);
        String host = cmdLine.getOption("host");
        String port = cmdLine.getOption("port");
        if (host != null) {
            cmdContext.setCandidateHosts(IPHelper.findCandidateIPs(host));
            cmdContext.setPort(port == null ? 0 : Integer.parseInt(port));
        }
        cmdContext.setUsername(cmdLine.getOption("username"));
        cmdContext.setPassword(cmdLine.getOption("password"));
        boolean bl = debugMode = cmdLine.getOption("debug") != null;
        if (debugMode) {
            LogCommand.setDebug(true);
        }
        if ((cd = service.getCommand(cmdName)) == null) {
            log.error((Object)("No such command was registered:  " + cmdName));
            System.exit(1);
        }
        if ((rcmds = args.length - 1) > 0) {
            String[] newArgs = new String[rcmds];
            System.arraycopy(args, 1, newArgs, 0, rcmds);
        } else {
            String[] newArgs = new String[]{};
        }
        try {
            service.runCommand(cd, cmdLine);
        }
        catch (Throwable e) {
            log.error((Object)e);
            System.exit(2);
        }
        finally {
            try {
                RepositoryInstance repo;
                if (cmdContext.isCurrentRepositorySet() && (repo = cmdContext.getRepositoryInstance()) != null) {
                    repo.close();
                }
                NuxeoClient.getInstance().tryDisconnect();
                log.info((Object)"Bye.");
                Framework.shutdown();
                System.exit(0);
            }
            catch (Exception e) {
                log.error((Object)"Failed to Disconnect.", (Throwable)e);
            }
        }
    }
}

