/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell;

import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.ecm.shell.Command;
import org.nuxeo.ecm.shell.CommandContext;
import org.nuxeo.ecm.shell.CommandDescriptor;
import org.nuxeo.ecm.shell.CommandLine;
import org.nuxeo.ecm.shell.CommandOption;
import org.nuxeo.ecm.shell.Main;
import org.nuxeo.ecm.shell.commands.scripting.ScriptingCommandDescriptor;
import org.nuxeo.osgi.application.StandaloneApplication;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;

public class CommandLineService
extends DefaultComponent
implements FrameworkListener {
    private static final Log log = LogFactory.getLog(CommandLineService.class);
    public static final ComponentName NAME = new ComponentName("org.nuxeo.runtime.client.CommandLineService");
    private Map<String, CommandDescriptor> cmds;
    private Map<String, CommandOption> options;
    private Map<String, CommandOption> shortcuts;
    CommandContext commandContext;

    public void activate(ComponentContext context) throws Exception {
        this.cmds = new Hashtable<String, CommandDescriptor>();
        this.options = new Hashtable<String, CommandOption>();
        this.shortcuts = new Hashtable<String, CommandOption>();
        this.commandContext = new CommandContext(this);
        context.getRuntimeContext().getBundle().getBundleContext().addFrameworkListener((FrameworkListener)this);
        this.reload();
    }

    public void reload() {
        File scriptsDir;
        File home = Environment.getDefault().getHome();
        if (home == null) {
            home = new File(".");
        }
        if ((scriptsDir = new File(home, "scripts")).isDirectory()) {
            for (File file : scriptsDir.listFiles()) {
                ScriptingCommandDescriptor cmd = new ScriptingCommandDescriptor(file);
                this.cmds.put(cmd.getName(), cmd);
            }
        }
    }

    public void deactivate(ComponentContext context) throws Exception {
        context.getRuntimeContext().getBundle().getBundleContext().removeFrameworkListener((FrameworkListener)this);
        this.cmds.clear();
        this.options.clear();
        this.shortcuts.clear();
        this.cmds = null;
        this.options = null;
        this.shortcuts = null;
        this.commandContext = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals("commands")) {
            CommandOption[] opts;
            CommandDescriptor cmd = (CommandDescriptor)contribution;
            String name = cmd.getName();
            this.cmds.put(name, cmd);
            if (cmd.getAliases() != null) {
                for (String alias : cmd.getAliases()) {
                    this.cmds.put(alias, cmd);
                }
            }
            if ((opts = cmd.getOptions()) != null) {
                for (CommandOption opt : opts) {
                    opt.setCommand(name);
                    this.addCommandOption(opt);
                }
            }
        } else if (extensionPoint.equals("options")) {
            CommandOption arg = (CommandOption)contribution;
            this.addCommandOption(arg);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals("commands")) {
            CommandDescriptor cmd = (CommandDescriptor)contribution;
            this.cmds.remove(cmd.getName());
            CommandOption[] opts = cmd.getOptions();
            if (opts != null) {
                for (CommandOption opt : opts) {
                    this.removeCommandOption(opt);
                }
            }
        } else if (extensionPoint.equals("options")) {
            CommandOption arg = (CommandOption)contribution;
            this.removeCommandOption(arg);
        }
    }

    public CommandDescriptor getCommand(String name) {
        return this.cmds.get(name);
    }

    public void addCommand(CommandDescriptor cmd) {
        this.cmds.put(cmd.getName(), cmd);
    }

    public void removeCommand(String name) {
        this.cmds.remove(name);
    }

    public CommandDescriptor[] getCommands() {
        return this.cmds.values().toArray(new CommandDescriptor[this.cmds.size()]);
    }

    public String[] getCommandNames() {
        return this.cmds.keySet().toArray(new String[this.cmds.size()]);
    }

    public CommandDescriptor[] getSortedCommands() {
        Object[] commands = this.getCommands();
        Arrays.sort(commands);
        return commands;
    }

    public CommandDescriptor[] getMatchingCommands(String prefix) {
        ArrayList<CommandDescriptor> result = new ArrayList<CommandDescriptor>();
        for (CommandDescriptor cmd : this.cmds.values()) {
            if (!cmd.getName().startsWith(prefix)) continue;
            result.add(cmd);
        }
        Object[] commands = result.toArray(new CommandDescriptor[result.size()]);
        Arrays.sort(commands);
        return commands;
    }

    public CommandOption getCommandOption(String name) {
        return this.options.get(name);
    }

    public CommandOption[] getCommandOptions() {
        return this.options.values().toArray(new CommandOption[this.options.size()]);
    }

    public void addCommandOption(CommandOption arg) {
        this.options.put(arg.name, arg);
        if (arg.shortcut != null) {
            this.shortcuts.put(arg.shortcut, arg);
        }
    }

    public void removeCommandOption(CommandOption arg) {
        this.options.remove(arg.name);
        if (arg.shortcut != null) {
            this.shortcuts.remove(arg.shortcut);
        }
    }

    public CommandContext getCommandContext() {
        return this.commandContext;
    }

    public CommandLine parse(String[] args, boolean validate) throws ParseException {
        CommandDescriptor cmd;
        LinkedList<CommandOption> queue = new LinkedList<CommandOption>();
        CommandLine cmdLine = new CommandLine(this);
        if (args == null || args.length == 0) {
            return cmdLine;
        }
        int k = 0;
        if (args[0].startsWith("-")) {
            cmdLine.addCommand("interactive");
        } else {
            k = 1;
            cmdLine.addCommand(args[0]);
        }
        if (validate && (cmd = this.getCommand(cmdLine.getCommand())) != null && cmd.isDynamicScript()) {
            validate = false;
        }
        for (int i = k; i < args.length; ++i) {
            CommandOption opt;
            String arg = args[i];
            if (arg.startsWith("-")) {
                char[] chars;
                if (arg.startsWith("-", 1)) {
                    opt = this.options.get(arg = arg.substring(2));
                    if (opt == null) {
                        if (!validate) continue;
                        throw new ParseException("Option is not recognized: " + arg, 0);
                    }
                    cmdLine.addOption(opt.name);
                    if (opt.isFlag()) continue;
                    queue.add(opt);
                    continue;
                }
                arg = arg.substring(1);
                for (char c : chars = arg.toCharArray()) {
                    opt = this.shortcuts.get(String.valueOf(c));
                    if (opt == null) {
                        if (!validate) continue;
                        throw new ParseException("Option is not recognized: " + c, 0);
                    }
                    cmdLine.addOption(opt.name);
                    if (opt.isFlag()) continue;
                    queue.add(opt);
                }
                continue;
            }
            opt = (CommandOption)queue.poll();
            if (opt != null) {
                cmdLine.addOptionValue(opt.name, arg);
                continue;
            }
            cmdLine.addParameter(arg);
        }
        if (validate) {
            if (!queue.isEmpty()) {
                StringBuffer logMsg = new StringBuffer();
                logMsg.append("Syntax error. The following options had no values:");
                while (!queue.isEmpty()) {
                    logMsg.append(" * " + queue.poll());
                }
                log.info((Object)logMsg);
            }
        } else if (!queue.isEmpty()) {
            while (!queue.isEmpty()) {
                CommandOption opt = (CommandOption)queue.poll();
                cmdLine.addOption(opt.name);
            }
        }
        return cmdLine;
    }

    public void runCommand(CommandDescriptor cd, CommandLine cmdLine) throws Exception {
        Command command = cd.newInstance();
        command.run(cmdLine);
    }

    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 1) {
            Environment env = Environment.getDefault();
            if (env == null) {
                log.error((Object)"Could not start command line service. This service works only with nxshell launcher");
                return;
            }
            String[] args = env.getCommandLineArguments();
            int k = -1;
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].equals("-console")) continue;
                k = i + 1;
                break;
            }
            if (k == -1) {
                return;
            }
            final String[] newArgs = new String[args.length - k];
            if (newArgs.length > 0) {
                System.arraycopy(args, k, newArgs, 0, newArgs.length);
            }
            Runnable task = new Runnable(){

                public void run() {
                    Main.main(newArgs);
                }
            };
            StandaloneApplication.setMainTask((Runnable)task);
            env.getProperties().put("mainTask", task);
        }
    }
}

