/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql.repository;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.directory.sql.repository.Column;
import org.nuxeo.ecm.directory.sql.repository.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Update
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Dialect dialect;
    private Table table;
    private List<Column> columns;
    private String where;

    public Update(Dialect dialect) {
        this.dialect = dialect;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(List<Column> columns) {
        this.columns = new ArrayList<Column>(columns);
    }

    public void addColumn(Column column) {
        this.columns.add(column);
    }

    public String getStatement() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("update ");
        buf.append(this.table.getQuotedName(this.dialect));
        buf.append(" set ");
        LinkedList<String> updatedColumns = new LinkedList<String>();
        for (Column column : this.columns) {
            if (column.isIdentity()) continue;
            updatedColumns.add(column.getQuotedName(this.dialect) + " = ?");
        }
        buf.append(StringUtils.join(updatedColumns, (String)", "));
        if (this.where != null) {
            buf.append(" where ");
            buf.append(this.where);
        }
        return buf.toString();
    }

    public void setWhere(String whereString) {
        this.where = whereString;
    }
}

