/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.directory.AbstractReference;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.sql.SQLDirectory;
import org.nuxeo.ecm.directory.sql.SQLDirectoryProxy;
import org.nuxeo.ecm.directory.sql.SQLHelper;
import org.nuxeo.ecm.directory.sql.SQLSession;
import org.nuxeo.ecm.directory.sql.repository.Column;
import org.nuxeo.ecm.directory.sql.repository.ConfigurationException;
import org.nuxeo.ecm.directory.sql.repository.Delete;
import org.nuxeo.ecm.directory.sql.repository.FieldMapper;
import org.nuxeo.ecm.directory.sql.repository.Insert;
import org.nuxeo.ecm.directory.sql.repository.Select;
import org.nuxeo.ecm.directory.sql.repository.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XObject(value="tableReference")
public class TableReference
extends AbstractReference {
    @XNode(value="@table")
    protected String tableName;
    @XNode(value="@sourceColumn")
    protected String sourceColumn;
    @XNode(value="@targetColumn")
    protected String targetColumn;
    @XNode(value="@schema")
    protected String schemaName;
    @XNode(value="@dataFile")
    protected String dataFileName;
    private Table table;
    private Dialect dialect;
    private boolean initialized = false;

    @XNode(value="@field")
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @XNode(value="@directory")
    public void setTargetDirectoryName(String targetDirectoryName) {
        this.targetDirectoryName = targetDirectoryName;
    }

    private SQLDirectory getSQLSourceDirectory() throws DirectoryException {
        Object dir = this.getSourceDirectory();
        if (dir instanceof SQLDirectoryProxy) {
            dir = ((SQLDirectoryProxy)dir).getDirectory();
        }
        return (SQLDirectory)((Object)dir);
    }

    private void initialize(SQLSession sqlSession) throws DirectoryException {
        SQLDirectory directory = this.getSQLSourceDirectory();
        String createTablePolicy = directory.getConfig().createTablePolicy;
        Table table = this.getTable();
        Dialect dialect = this.getDialect();
        SQLHelper helper = new SQLHelper(sqlSession.sqlConnection, dialect, table, this.dataFileName, createTablePolicy);
        helper.setupTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLinks(String sourceId, List<String> targetIds) throws DirectoryException {
        if (targetIds == null) {
            return;
        }
        SQLSession session = this.getSQLSession();
        try {
            this.addLinks(sourceId, targetIds, session);
            session.commit();
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLinks(List<String> sourceIds, String targetId) throws DirectoryException {
        if (sourceIds == null) {
            return;
        }
        SQLSession session = this.getSQLSession();
        try {
            this.addLinks(sourceIds, targetId, session);
            session.commit();
        }
        finally {
            session.close();
        }
    }

    public void addLinks(String sourceId, List<String> targetIds, SQLSession session) throws DirectoryException {
        if (targetIds == null) {
            return;
        }
        for (String targetId : targetIds) {
            this.addLink(sourceId, targetId, session, true);
        }
    }

    public void addLinks(List<String> sourceIds, String targetId, SQLSession session) throws DirectoryException {
        if (sourceIds == null) {
            return;
        }
        for (String sourceId : sourceIds) {
            this.addLink(sourceId, targetId, session, true);
        }
    }

    public boolean exists(String sourceId, String targetId, SQLSession session) throws DirectoryException {
        Table table = this.getTable();
        Dialect dialect = this.getDialect();
        Select select = new Select(dialect);
        select.setFrom(table.getQuotedName(dialect));
        select.setWhat("count(*)");
        String whereString = String.format("%s = ? and %s = ?", table.getColumn(this.sourceColumn).getQuotedName(dialect), table.getColumn(this.targetColumn).getQuotedName(dialect));
        select.setWhere(whereString);
        String selectSql = select.getStatement();
        PreparedStatement ps = null;
        try {
            ps = session.sqlConnection.prepareStatement(selectSql);
            ps.setString(1, sourceId);
            ps.setString(2, targetId);
            ResultSet rs = ps.executeQuery();
            rs.next();
            boolean bl = rs.getInt(1) > 0;
            return bl;
        }
        catch (SQLException e) {
            throw new DirectoryException(String.format("error reading link from %s to %s", sourceId, targetId), (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sqle) {
                throw new DirectoryException((Throwable)sqle);
            }
        }
    }

    public void addLink(String sourceId, String targetId, SQLSession session, boolean checkExisting) throws DirectoryException {
        if (checkExisting && this.exists(sourceId, targetId, session)) {
            return;
        }
        Table table = this.getTable();
        Dialect dialect = this.getDialect();
        Insert insert = new Insert(dialect);
        insert.setTable(table);
        insert.addColumn(table.getColumn(this.sourceColumn));
        insert.addColumn(table.getColumn(this.targetColumn));
        String insertSql = insert.getStatement();
        PreparedStatement ps = null;
        try {
            ps = session.sqlConnection.prepareStatement(insertSql);
            ps.setString(1, sourceId);
            ps.setString(2, targetId);
            ps.execute();
        }
        catch (SQLException e) {
            throw new DirectoryException(String.format("error adding link from %s to %s", sourceId, targetId), (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sqle) {
                throw new DirectoryException((Throwable)sqle);
            }
        }
    }

    protected List<String> getIdsFor(String valueColumn, String filterColumn, String filterValue) throws DirectoryException {
        Table table = this.getTable();
        Dialect dialect = this.getDialect();
        Select select = new Select(dialect);
        select.setWhat(table.getColumn(valueColumn).getQuotedName(dialect));
        select.setFrom(table.getQuotedName(dialect));
        select.setWhere(table.getColumn(filterColumn).getQuotedName(dialect) + " = ?");
        String sql = select.getStatement();
        SQLSession session = this.getSQLSession();
        LinkedList<String> ids = new LinkedList<String>();
        try {
            PreparedStatement ps = session.sqlConnection.prepareStatement(sql);
            ps.setString(1, filterValue);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ids.add(rs.getString(valueColumn));
            }
            LinkedList<String> linkedList = ids;
            return linkedList;
        }
        catch (SQLException e) {
            throw new DirectoryException("error fetching reference values: ", (Throwable)e);
        }
        finally {
            session.close();
        }
    }

    public List<String> getSourceIdsForTarget(String targetId) throws DirectoryException {
        return this.getIdsFor(this.sourceColumn, this.targetColumn, targetId);
    }

    public List<String> getTargetIdsForSource(String sourceId) throws DirectoryException {
        return this.getIdsFor(this.targetColumn, this.sourceColumn, sourceId);
    }

    public void removeLinksFor(String column, String entryId, SQLSession session) throws DirectoryException {
        Table table = this.getTable();
        Dialect dialect = this.getDialect();
        String sql = String.format("DELETE FROM %s WHERE %s = ?", table.getQuotedName(dialect), table.getColumn(column).getQuotedName(dialect));
        PreparedStatement ps = null;
        try {
            ps = session.sqlConnection.prepareStatement(sql);
            ps.setString(1, entryId);
            ps.execute();
        }
        catch (SQLException e) {
            throw new DirectoryException("error remove links to " + entryId, (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException sqle) {
                throw new DirectoryException((Throwable)sqle);
            }
        }
    }

    public void removeLinksForSource(String sourceId, SQLSession session) throws DirectoryException {
        this.removeLinksFor(this.sourceColumn, sourceId, session);
    }

    public void removeLinksForTarget(String targetId, SQLSession session) throws DirectoryException {
        this.removeLinksFor(this.targetColumn, targetId, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLinksForSource(String sourceId) throws DirectoryException {
        SQLSession session = this.getSQLSession();
        try {
            this.removeLinksForSource(sourceId, session);
            session.commit();
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLinksForTarget(String targetId) throws DirectoryException {
        SQLSession session = this.getSQLSession();
        try {
            this.removeLinksForTarget(targetId, session);
            session.commit();
        }
        finally {
            session.close();
        }
    }

    public void setIdsFor(String idsColumn, List<String> ids, String filterColumn, String filterValue, SQLSession session) throws DirectoryException {
        block31: {
            LinkedList<String> idsToDelete = new LinkedList<String>();
            HashSet<String> idsToAdd = new HashSet<String>();
            if (ids != null) {
                idsToAdd.addAll(ids);
            }
            Table table = this.getTable();
            Dialect dialect = this.getDialect();
            String selectSql = String.format("SELECT %s FROM %s WHERE %s = ?", table.getColumn(idsColumn).getQuotedName(dialect), table.getQuotedName(dialect), table.getColumn(filterColumn).getQuotedName(dialect));
            PreparedStatement ps = null;
            try {
                ps = session.sqlConnection.prepareStatement(selectSql);
                ps.setString(1, filterValue);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    String existingId = rs.getString(1);
                    if (idsToAdd.contains(existingId)) {
                        idsToAdd.remove(existingId);
                        continue;
                    }
                    idsToDelete.add(existingId);
                }
            }
            catch (SQLException e) {
                throw new DirectoryException("failed to fetch existing links for " + filterValue, (Throwable)e);
            }
            finally {
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException sqle) {
                    throw new DirectoryException((Throwable)sqle);
                }
            }
            if (!idsToDelete.isEmpty()) {
                Delete delete = new Delete(dialect);
                delete.setTable(table);
                String whereString = String.format("%s = ? AND %s = ?", table.getColumn(filterColumn).getQuotedName(dialect), table.getColumn(idsColumn).getQuotedName(dialect));
                delete.setWhere(whereString);
                String deleteSql = delete.getStatement();
                try {
                    ps = session.sqlConnection.prepareStatement(deleteSql);
                    for (String unwantedId : idsToDelete) {
                        ps.setString(1, filterValue);
                        ps.setString(2, unwantedId);
                        ps.execute();
                    }
                }
                catch (SQLException e) {
                    throw new DirectoryException("failed to remove unwanted links for " + filterValue, (Throwable)e);
                }
                finally {
                    try {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                    catch (SQLException sqle) {
                        throw new DirectoryException((Throwable)sqle);
                    }
                }
            }
            if (idsToAdd.isEmpty()) break block31;
            if (filterColumn.equals(this.sourceColumn)) {
                for (String missingId : idsToAdd) {
                    this.addLink(filterValue, missingId, session, false);
                }
            } else {
                for (String missingId : idsToAdd) {
                    this.addLink(missingId, filterValue, session, false);
                }
            }
        }
    }

    public void setSourceIdsForTarget(String targetId, List<String> sourceIds, SQLSession session) throws DirectoryException {
        this.setIdsFor(this.sourceColumn, sourceIds, this.targetColumn, targetId, session);
    }

    public void setTargetIdsForSource(String sourceId, List<String> targetIds, SQLSession session) throws DirectoryException {
        this.setIdsFor(this.targetColumn, targetIds, this.sourceColumn, sourceId, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceIdsForTarget(String targetId, List<String> sourceIds) throws DirectoryException {
        SQLSession session = this.getSQLSession();
        try {
            this.setSourceIdsForTarget(targetId, sourceIds, session);
            session.commit();
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTargetIdsForSource(String sourceId, List<String> targetIds) throws DirectoryException {
        SQLSession session = this.getSQLSession();
        try {
            this.setTargetIdsForSource(sourceId, targetIds, session);
            session.commit();
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SQLSession getSQLSession() throws DirectoryException {
        if (!this.initialized) {
            SQLSession sqlSession = (SQLSession)this.getSourceDirectory().getSession();
            try {
                this.initialize(sqlSession);
                this.initialized = true;
                sqlSession.commit();
            }
            finally {
                sqlSession.close();
            }
        }
        return (SQLSession)this.getSourceDirectory().getSession();
    }

    protected void maybeInitialize(SQLSession sqlSession) throws DirectoryException {
        if (!this.initialized) {
            this.initialize(sqlSession);
            this.initialized = true;
        }
    }

    public Table getTable() throws DirectoryException {
        if (this.table == null) {
            try {
                this.table = new Table(this.tableName);
                String columnName = this.sourceColumn;
                Column column = new Column(columnName, FieldMapper.getSqlField("string"), columnName);
                this.table.addColumn(column);
                columnName = this.targetColumn;
                column = new Column(columnName, FieldMapper.getSqlField("string"), columnName);
                this.table.addColumn(column);
            }
            catch (ConfigurationException e) {
                throw new DirectoryException((Throwable)e);
            }
        }
        return this.table;
    }

    private Dialect getDialect() throws DirectoryException {
        if (this.dialect == null) {
            Object dir = this.getSourceDirectory();
            if (dir instanceof SQLDirectoryProxy) {
                dir = ((SQLDirectoryProxy)dir).getDirectory();
            }
            this.dialect = ((SQLDirectory)((Object)dir)).getDialect();
        }
        return this.dialect;
    }

    public String getSourceColumn() {
        return this.sourceColumn;
    }

    public String getTargetColumn() {
        return this.targetColumn;
    }

    public String getTargetDirectoryName() {
        return this.targetDirectoryName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getDataFileName() {
        return this.dataFileName;
    }
}

