/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.memory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.memory.MemoryDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryDirectorySession
extends BaseSession {
    protected final MemoryDirectory directory;
    protected final Map<String, Map<String, Object>> data;

    public MemoryDirectorySession(MemoryDirectory directory) {
        this.directory = directory;
        this.data = Collections.synchronizedMap(new LinkedHashMap());
    }

    public boolean authenticate(String username, String password) throws DirectoryException {
        Map<String, Object> map = this.data.get(username);
        if (map == null) {
            return false;
        }
        String expected = (String)map.get(this.directory.passwordField);
        if (expected == null) {
            return false;
        }
        return expected.equals(password);
    }

    public void close() {
    }

    public void commit() {
    }

    public void rollback() throws DirectoryException {
        throw new RuntimeException("Not implemented");
    }

    public DocumentModel createEntry(Map<String, Object> fieldMap) throws DirectoryException {
        Object rawId = fieldMap.get(this.directory.idField);
        if (rawId == null) {
            throw new DirectoryException("Missing id");
        }
        String id = String.valueOf(rawId);
        Map<String, Object> map = this.data.get(id);
        if (map != null) {
            throw new DirectoryException(String.format("Entry with id %s already exists", id));
        }
        map = new HashMap<String, Object>();
        this.data.put(id, map);
        for (Map.Entry<String, Object> e : fieldMap.entrySet()) {
            String fieldName = e.getKey();
            if (!this.directory.schemaSet.contains(fieldName)) continue;
            map.put(fieldName, e.getValue());
        }
        return this.getEntry(id);
    }

    public DocumentModel getEntry(String id) throws DirectoryException {
        return this.getEntry(id, true);
    }

    public DocumentModel getEntry(String id, boolean fetchReferences) throws DirectoryException {
        Map<String, Object> map = this.data.get(id);
        if (map == null) {
            return null;
        }
        try {
            DocumentModel entry = BaseSession.createEntryModel(null, (String)this.directory.schemaName, (String)id, map, (boolean)this.isReadOnly());
            return entry;
        }
        catch (PropertyException e) {
            throw new DirectoryException((Throwable)e);
        }
    }

    public void updateEntry(DocumentModel docModel) throws DirectoryException {
        DataModel dataModel;
        String id = docModel.getId();
        try {
            dataModel = docModel.getDataModel(this.directory.schemaName);
        }
        catch (ClientException e) {
            throw new DirectoryException((Throwable)e);
        }
        Map<String, Object> map = this.data.get(id);
        if (map == null) {
            return;
        }
        for (String fieldName : this.directory.schemaSet) {
            try {
                if (!dataModel.isDirty(fieldName)) continue;
                if (fieldName.equals(this.directory.idField)) {
                }
            }
            catch (PropertyNotFoundException e) {}
            continue;
            try {
                map.put(fieldName, dataModel.getData(fieldName));
            }
            catch (PropertyException e) {
                throw new ClientRuntimeException((Throwable)e);
            }
        }
        dataModel.getDirtyFields().clear();
    }

    public DocumentModelList getEntries() throws DirectoryException {
        DocumentModelListImpl list = new DocumentModelListImpl();
        for (String id : this.data.keySet()) {
            list.add((Object)this.getEntry(id));
        }
        return list;
    }

    public void deleteEntry(String id) throws DirectoryException {
        this.data.remove(id);
    }

    public void deleteEntry(String id, Map<String, String> map) throws DirectoryException {
        throw new DirectoryException("Not implemented");
    }

    public void deleteEntry(DocumentModel docModel) throws DirectoryException {
        this.deleteEntry(docModel.getId());
    }

    public String getIdField() {
        return this.directory.idField;
    }

    public String getPasswordField() {
        return this.directory.passwordField;
    }

    public boolean isAuthenticating() {
        return this.directory.passwordField != null;
    }

    public boolean isReadOnly() {
        return this.directory.isReadOnly();
    }

    public DocumentModelList query(Map<String, Serializable> filter) throws DirectoryException {
        return this.query(filter, Collections.<String>emptySet());
    }

    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext) throws DirectoryException {
        return this.query(filter, fulltext, Collections.<String, String>emptyMap());
    }

    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy) throws DirectoryException {
        return this.query(filter, fulltext, orderBy, true);
    }

    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy, boolean fetchReferences) throws DirectoryException {
        DocumentModelListImpl results = new DocumentModelListImpl();
        HashMap<String, Serializable> filt = new HashMap<String, Serializable>();
        for (Map.Entry<String, Serializable> entry : filter.entrySet()) {
            String fieldName = entry.getKey();
            if (!this.directory.schemaSet.contains(fieldName)) continue;
            filt.put(fieldName, entry.getValue());
        }
        block1: for (Map.Entry<String, Object> entry : this.data.entrySet()) {
            String id = entry.getKey();
            Map map = (Map)entry.getValue();
            for (Map.Entry e : filt.entrySet()) {
                String fieldName = (String)e.getKey();
                Object expected = e.getValue();
                Object value = map.get(fieldName);
                if (!(value == null ? expected != null : (fulltext != null && fulltext.contains(fieldName) ? !value.toString().toLowerCase().startsWith(expected.toString().toLowerCase()) : !value.equals(expected)))) continue;
                continue block1;
            }
            results.add((Object)this.getEntry(id));
        }
        if (orderBy != null && !orderBy.isEmpty()) {
            this.directory.orderEntries((List<DocumentModel>)results, orderBy);
        }
        return results;
    }

    public List<String> getProjection(Map<String, Serializable> filter, String columnName) throws DirectoryException {
        return this.getProjection(filter, Collections.<String>emptySet(), columnName);
    }

    public List<String> getProjection(Map<String, Serializable> filter, Set<String> fulltext, String columnName) throws DirectoryException {
        DocumentModelList l = this.query(filter, fulltext);
        ArrayList<String> results = new ArrayList<String>(l.size());
        for (DocumentModel doc : l) {
            Object value;
            try {
                value = doc.getProperty(this.directory.schemaName, columnName);
            }
            catch (ClientException e) {
                throw new DirectoryException((Throwable)e);
            }
            if (value != null) {
                results.add(value.toString());
                continue;
            }
            results.add(null);
        }
        return results;
    }

    public DocumentModel createEntry(DocumentModel entry) throws ClientException {
        Map fieldMap = entry.getProperties(this.directory.schemaName);
        return this.createEntry(fieldMap);
    }

    public boolean hasEntry(String id) throws ClientException {
        return this.data.containsKey(id);
    }
}

