/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import java.util.List;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.directory.AbstractReference;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XObject(value="inverseReference")
public class InverseReference
extends AbstractReference {
    @XNode(value="@dualReferenceField")
    protected String dualReferenceName;
    protected Reference dualReference;

    @XNode(value="@field")
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    @XNode(value="@directory")
    public void setTargetDirectoryName(String targetDirectoryName) {
        this.targetDirectoryName = targetDirectoryName;
    }

    protected void checkDualReference() throws DirectoryException {
        if (this.dualReference == null) {
            this.dualReference = this.getTargetDirectory().getReference(this.dualReferenceName);
        }
        if (this.dualReference == null) {
            throw new DirectoryException("could not find reference " + this.dualReferenceName);
        }
        if (this.dualReference instanceof InverseReference) {
            throw new DirectoryException(String.format("InverseReference %s cannot refere to InverseReference %s", this.getFieldName(), this.dualReferenceName));
        }
    }

    public void addLinks(String sourceId, List<String> targetIds) throws DirectoryException {
        this.checkDualReference();
        this.dualReference.addLinks(targetIds, sourceId);
    }

    public void addLinks(List<String> sourceIds, String targetId) throws DirectoryException {
        this.checkDualReference();
        this.dualReference.addLinks(targetId, sourceIds);
    }

    public void removeLinksForTarget(String targetId) throws DirectoryException {
        this.checkDualReference();
        this.dualReference.removeLinksForSource(targetId);
    }

    public void removeLinksForSource(String sourceId) throws DirectoryException {
        this.checkDualReference();
        this.dualReference.removeLinksForTarget(sourceId);
    }

    public List<String> getSourceIdsForTarget(String targetId) throws DirectoryException {
        this.checkDualReference();
        return this.dualReference.getTargetIdsForSource(targetId);
    }

    public List<String> getTargetIdsForSource(String sourceId) throws DirectoryException {
        this.checkDualReference();
        return this.dualReference.getSourceIdsForTarget(sourceId);
    }

    public void setTargetIdsForSource(String sourceId, List<String> targetIds) throws DirectoryException {
        this.checkDualReference();
        this.dualReference.setSourceIdsForTarget(sourceId, targetIds);
    }

    public void setSourceIdsForTarget(String targetId, List<String> sourceIds) throws DirectoryException {
        this.checkDualReference();
        this.dualReference.setTargetIdsForSource(targetId, sourceIds);
    }
}

