/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.jndi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.NotContextException;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamingContext
implements Context {
    private static final String ROOT_CONTEXT_NAME = "ROOT";
    private static final NameParser nameParser = new NamingContextNameParser();
    private final Map<Object, Object> objects = Collections.synchronizedMap(new HashMap());
    private final NamingContext parent;
    private final String contextName;
    private final Context remoteContext;
    private boolean isDestroyed;

    protected NamingContext(Context remoteContext) {
        this(remoteContext, null, ROOT_CONTEXT_NAME);
    }

    private NamingContext(Context remoteContext, NamingContext parent, String name) {
        this.remoteContext = remoteContext;
        this.parent = parent;
        this.contextName = name;
        this.isDestroyed = false;
    }

    @Override
    public Object addToEnvironment(String arg0, Object arg1) throws NamingException {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.checkIsDestroyed();
        this.rebind(name, obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind(nameParser.parse(name), obj);
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        this.checkIsDestroyed();
        Name parsedPrefix = NamingContext.getParsedName((Name)prefix.clone());
        Name parsedName = NamingContext.getParsedName(name);
        return parsedPrefix.addAll(parsedName);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        this.checkIsDestroyed();
        return this.composeName(nameParser.parse(name), nameParser.parse(prefix)).toString();
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        this.checkIsDestroyed();
        Name parsedName = NamingContext.getParsedName(name);
        if (parsedName.isEmpty() || parsedName.get(0).length() == 0) {
            throw new InvalidNameException("Name can not be empty!");
        }
        String subContextName = parsedName.get(0);
        Object boundObject = this.objects.get(parsedName.get(0));
        if (parsedName.size() == 1) {
            if (boundObject == null) {
                NamingContext subContext = new NamingContext(this.remoteContext, this, subContextName);
                this.objects.put(subContextName, subContext);
                return subContext;
            }
            throw new NameAlreadyBoundException("Name " + subContextName + " is already bound!");
        }
        if (boundObject instanceof Context) {
            return ((Context)boundObject).createSubcontext(parsedName.getSuffix(1));
        }
        throw new NotContextException("Expected Context but found " + boundObject);
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(nameParser.parse(name));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.checkIsDestroyed();
        Name parsedName = NamingContext.getParsedName(name);
        if (parsedName.isEmpty() || parsedName.get(0).length() == 0) {
            throw new InvalidNameException("Name can not be empty!");
        }
        String subContextName = parsedName.get(0);
        Object boundObject = this.objects.get(subContextName);
        if (boundObject == null) {
            throw new NameNotFoundException("Name " + subContextName + "not found in the context!");
        }
        if (!(boundObject instanceof NamingContext)) {
            throw new NotContextException();
        }
        NamingContext contextToDestroy = (NamingContext)boundObject;
        if (parsedName.size() == 1) {
            if (!contextToDestroy.objects.isEmpty()) throw new ContextNotEmptyException("Can not destroy non-empty Context!");
            this.objects.remove(subContextName);
            contextToDestroy.destroyInternal();
            return;
        } else {
            ((Context)boundObject).destroySubcontext(parsedName.getSuffix(1));
        }
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(nameParser.parse(name));
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        this.checkIsDestroyed();
        return nameParser;
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        this.checkIsDestroyed();
        return nameParser;
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.listBindings(name);
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(nameParser.parse(name));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        this.checkIsDestroyed();
        Name parsedName = NamingContext.getParsedName(name);
        if (parsedName.isEmpty()) {
            Vector<Binding> bindings = new Vector<Binding>();
            for (Object o : this.objects.keySet()) {
                String bindingName = (String)o;
                bindings.addElement(new Binding(bindingName, this.objects.get(bindingName)));
            }
            return new NamingEnumerationImpl(bindings);
        }
        Object subContext = this.objects.get(parsedName.get(0));
        if (subContext instanceof Context) {
            return ((Context)subContext).listBindings(parsedName.getSuffix(1));
        }
        if (subContext == null && !this.objects.containsKey(parsedName.get(0))) {
            throw new NameNotFoundException("Name " + name + " not found");
        }
        throw new NotContextException("Expected Context but found " + subContext);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.listBindings(nameParser.parse(name));
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        this.checkIsDestroyed();
        try {
            return this.lookupInternal(name);
        }
        catch (NameNotFoundException ex) {
            if (this.remoteContext != null) {
                return this.remoteContext.lookup(name);
            }
            throw new NameNotFoundException("Name " + name + " not found. ");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object lookupInternal(Name name) throws NamingException {
        Name parsedName = NamingContext.getParsedName(name);
        String nameComponent = parsedName.get(0);
        Object res = this.objects.get(nameComponent);
        if (!this.objects.containsKey(nameComponent)) {
            throw new NameNotFoundException("Name " + name + " not found.");
        }
        if (parsedName.size() > 1) {
            if (!(res instanceof NamingContext)) throw new NotContextException("Expected NamingContext but found " + res);
            return ((NamingContext)res).lookupInternal(parsedName.getSuffix(1));
        }
        if (!(res instanceof Reference)) return res;
        try {
            Hashtable env = new Hashtable();
            res = NamingManager.getObjectInstance(res, name, this, env);
            if (res == null) return res;
            this.objects.put(nameComponent, res);
            return res;
        }
        catch (NamingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NamingException(e.getMessage());
        }
    }

    @Override
    public Object lookup(String name) throws NamingException {
        this.checkIsDestroyed();
        try {
            return this.lookupInternal(name);
        }
        catch (NameNotFoundException ex) {
            if (this.remoteContext != null) {
                return this.remoteContext.lookup(name);
            }
            throw new NameNotFoundException("Name " + name + " not found. ");
        }
    }

    private Object lookupInternal(String name) throws NamingException {
        return this.lookupInternal(nameParser.parse(name));
    }

    @Override
    public Object lookupLink(Name arg0) throws NamingException {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public Object lookupLink(String arg0) throws NamingException {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.checkIsDestroyed();
        Name parsedName = NamingContext.getParsedName(name);
        if (parsedName.isEmpty() || parsedName.get(0).length() == 0) {
            throw new InvalidNameException("Name can not be empty!");
        }
        String nameToBind = parsedName.get(0);
        if (parsedName.size() == 1) {
            this.objects.put(nameToBind, obj);
        } else {
            Object boundObject = this.objects.get(nameToBind);
            if (boundObject instanceof Context) {
                ((Context)boundObject).bind(parsedName.getSuffix(1), obj);
            } else if (boundObject == null) {
                Context sub = this.createSubcontext(nameToBind);
                sub.bind(parsedName.getSuffix(1), obj);
            } else {
                throw new NotContextException("Expected Context but found " + boundObject);
            }
        }
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(nameParser.parse(name), obj);
    }

    @Override
    public Object removeFromEnvironment(String arg0) throws NamingException {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void rename(Name arg0, Name arg1) throws NamingException {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void rename(String arg0, String arg1) throws NamingException {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.checkIsDestroyed();
        Name parsedName = NamingContext.getParsedName(name);
        if (parsedName.isEmpty() || parsedName.get(0).length() == 0) {
            throw new InvalidNameException("Name can not be empty!");
        }
        String nameToRemove = parsedName.get(0);
        if (parsedName.size() == 1) {
            this.objects.remove(nameToRemove);
        } else {
            Object boundObject = this.objects.get(nameToRemove);
            if (boundObject instanceof Context) {
                ((Context)boundObject).unbind(parsedName.getSuffix(1));
            } else {
                if (!this.objects.containsKey(nameToRemove)) {
                    throw new NameNotFoundException("Can not find " + name);
                }
                throw new NotContextException("Expected Context but found " + boundObject);
            }
        }
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(nameParser.parse(name));
    }

    private void checkIsDestroyed() throws NoPermissionException {
        if (this.isDestroyed) {
            throw new NoPermissionException("Can not invoke operations on destroyed context!");
        }
    }

    private void destroyInternal() {
        this.isDestroyed = true;
    }

    private static Name getParsedName(Name name) throws NamingException {
        Name result;
        if (name instanceof CompositeName) {
            if (name.isEmpty()) {
                result = nameParser.parse("");
            } else if (name.size() > 1) {
                throw new InvalidNameException("Multiple name systems are not supported!");
            }
            result = nameParser.parse(name.get(0));
        } else {
            result = (Name)name.clone();
        }
        while (!result.isEmpty()) {
            if (result.get(0).length() == 0) {
                result.remove(0);
                continue;
            }
            if (result.get(result.size() - 1).length() != 0) break;
            result.remove(result.size() - 1);
        }
        for (int i = 1; i < result.size() - 1; ++i) {
            if (result.get(i).length() != 0) continue;
            throw new InvalidNameException("Empty intermediate components are not supported!");
        }
        return result;
    }

    String getCompoundStringName() throws NamingException {
        String compositeName = "";
        NamingContext curCtx = this;
        while (!curCtx.isRootContext()) {
            compositeName = this.composeName(compositeName, curCtx.contextName);
            curCtx = curCtx.parent;
        }
        return compositeName;
    }

    NamingContext getParentContext() {
        return this.parent;
    }

    String getAtomicName() {
        return this.contextName;
    }

    boolean isRootContext() {
        return this.parent == null;
    }

    public String toString() {
        try {
            return this.getCompoundStringName();
        }
        catch (NamingException e) {
            return super.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NamingEnumerationImpl
    implements NamingEnumeration<Binding> {
        private final Vector<Binding> elements;
        private int currentElement;

        NamingEnumerationImpl(Vector<Binding> elements) {
            this.elements = elements;
            this.currentElement = 0;
        }

        @Override
        public void close() {
            this.currentElement = 0;
            this.elements.clear();
        }

        @Override
        public boolean hasMore() {
            return this.hasMoreElements();
        }

        @Override
        public boolean hasMoreElements() {
            if (this.currentElement < this.elements.size()) {
                return true;
            }
            this.close();
            return false;
        }

        @Override
        public Binding next() {
            return this.nextElement();
        }

        @Override
        public Binding nextElement() {
            if (this.hasMoreElements()) {
                return this.elements.get(this.currentElement++);
            }
            throw new NoSuchElementException();
        }
    }

    public static class NamingContextNameParser
    implements NameParser {
        private static final Properties syntax = new Properties();

        public Name parse(String name) throws NamingException {
            return new CompoundName(name.replace('.', '/'), syntax);
        }

        static {
            syntax.put("jndi.syntax.direction", "left_to_right");
            syntax.put("jndi.syntax.separator", "/");
            syntax.put("jndi.syntax.ignorecase", "false");
            syntax.put("jndi.syntax.trimblanks", "yes");
        }
    }
}

