/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.plugins.text.extractors;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RFC822ToTextConverter
implements Converter {
    private static final Log log = LogFactory.getLog(RFC822ToTextConverter.class);
    private static final String MESSAGE_RFC822_MIMETYPE = "message/rfc822";
    private static final String TXT_MT = "text/plain";
    protected ConverterDescriptor descriptor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Blob extractTextFromMessage(Blob blob) {
        if (blob == null) {
            return null;
        }
        File f = null;
        OutputStream fo = null;
        try {
            MimeMessage msg = new MimeMessage((Session)null, blob.getStream());
            f = File.createTempFile("rfc822totext", ".txt");
            fo = new FileOutputStream(f);
            List<Part> parts = RFC822ToTextConverter.getAttachmentParts((Part)msg);
            RFC822ToTextConverter.writeInfo(fo, msg.getSubject());
            RFC822ToTextConverter.writeInfo(fo, msg.getFrom());
            RFC822ToTextConverter.writeInfo(fo, msg.getRecipients(Message.RecipientType.TO));
            RFC822ToTextConverter.writeInfo(fo, msg.getRecipients(Message.RecipientType.CC));
            for (Part part : parts) {
                RFC822ToTextConverter.writeInfo(fo, part.getFileName());
                RFC822ToTextConverter.writeInfo(fo, part.getDescription());
                byte[] extracted = RFC822ToTextConverter.extractTextFromMessagePart(part);
                if (extracted == null) continue;
                RFC822ToTextConverter.writeInfo(fo, extracted);
            }
            FileBlob outblob = new FileBlob((InputStream)new FileInputStream(f));
            outblob.setMimeType(this.descriptor.getDestinationMimeType());
            FileBlob fileBlob = outblob;
            return fileBlob;
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        finally {
            if (fo != null) {
                try {
                    fo.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
            if (f != null) {
                f.delete();
            }
        }
        return null;
    }

    protected static void writeInfo(OutputStream stream, Address address) {
        if (address != null) {
            try {
                stream.write(address.toString().getBytes());
                stream.write(" ".getBytes());
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    protected static void writeInfo(OutputStream stream, Address[] addresses) {
        if (addresses != null) {
            for (Address address : addresses) {
                RFC822ToTextConverter.writeInfo(stream, address);
            }
        }
    }

    protected static void writeInfo(OutputStream stream, String info) {
        if (info != null) {
            try {
                stream.write(info.getBytes());
                stream.write(" ".getBytes());
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    protected static void writeInfo(OutputStream stream, byte[] info) {
        if (info != null) {
            try {
                stream.write(info);
                stream.write(" ".getBytes());
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    protected static byte[] extractTextFromMessagePart(Part p) throws Exception {
        ContentType contentType = new ContentType(p.getContentType());
        String baseType = contentType.getBaseType();
        if (TXT_MT.equals(baseType)) {
            Object content = p.getContent();
            if (content instanceof String) {
                return ((String)content).getBytes();
            }
            return null;
        }
        ConversionService cs = (ConversionService)Framework.getLocalService(ConversionService.class);
        String converterName = cs.getConverterName(baseType, TXT_MT);
        if (converterName == null) {
            return null;
        }
        BlobHolder result = cs.convert(converterName, (BlobHolder)new SimpleBlobHolder((Blob)new FileBlob(p.getInputStream())), null);
        return result.getBlob().getByteArray();
    }

    protected static List<Part> getAttachmentParts(Part p) throws Exception {
        ArrayList<Part> res = new ArrayList<Part>();
        if (p.isMimeType(MESSAGE_RFC822_MIMETYPE)) {
            res.addAll(RFC822ToTextConverter.getAttachmentParts((Part)p.getContent()));
        } else if (p.isMimeType("multipart/alternative")) {
            Multipart mp = (Multipart)p.getContent();
            int count = mp.getCount();
            BodyPart alternativePart = null;
            for (int i = 0; i < count; ++i) {
                BodyPart subPart = mp.getBodyPart(i);
                if (subPart.isMimeType(TXT_MT)) {
                    alternativePart = subPart;
                    break;
                }
                if (subPart.isMimeType("text/*")) {
                    alternativePart = subPart;
                    continue;
                }
                res.addAll(RFC822ToTextConverter.getAttachmentParts((Part)subPart));
            }
            if (alternativePart != null) {
                res.add((Part)alternativePart);
            }
        } else if (p.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)p.getContent();
            int count = mp.getCount();
            for (int i = 0; i < count; ++i) {
                res.addAll(RFC822ToTextConverter.getAttachmentParts((Part)mp.getBodyPart(i)));
            }
        } else {
            res.add(p);
        }
        return res;
    }

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        Blob outputBlob;
        Blob inputBlob;
        try {
            inputBlob = blobHolder.getBlob();
        }
        catch (Exception e) {
            throw new ConversionException("Error while getting blob from Holder", e);
        }
        try {
            outputBlob = this.extractTextFromMessage(inputBlob);
        }
        catch (Exception e) {
            throw new ConversionException("Error in Text conversion", e);
        }
        return new SimpleCachableBlobHolder(outputBlob);
    }

    public void init(ConverterDescriptor descriptor) {
        this.descriptor = descriptor;
    }
}

