/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.url.codec;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.utils.DocumentModelUtils;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.service.AbstractDocumentViewCodec;

public class DocumentFileCodec
extends AbstractDocumentViewCodec {
    public static final String PREFIX = "nxfile";
    public static final String FILE_PROPERTY_PATH_KEY = "FILE_PROPERTY_PATH";
    @Deprecated
    public static final String FILENAME_PROPERTY_PATH_KEY = "FILENAME_PROPERTY_PATH";
    public static final String FILENAME_KEY = "FILENAME";
    private static final Log log = LogFactory.getLog(DocumentFileCodec.class);
    public static final String URLPattern = "/(\\w+)/([a-zA-Z_0-9\\-]+)(/([a-zA-Z_0-9/:\\-\\.\\]\\[]*))+(/([^\\?]*))+(\\?)?(.*)?";

    public DocumentFileCodec() {
    }

    public DocumentFileCodec(String prefix) {
    }

    public String getPrefix() {
        if (this.prefix != null) {
            return this.prefix;
        }
        return PREFIX;
    }

    public String getUrlFromDocumentView(DocumentView docView) {
        DocumentLocation docLoc = docView.getDocumentLocation();
        String filepath = docView.getParameter(FILE_PROPERTY_PATH_KEY);
        String filename = docView.getParameter(FILENAME_KEY);
        if (docLoc != null && filepath != null && filename != null) {
            ArrayList<String> items = new ArrayList<String>();
            items.add(this.getPrefix());
            items.add(docLoc.getServerName());
            items.add(docLoc.getDocRef().toString());
            items.add(filepath);
            items.add(URIUtils.quoteURIPathComponent((String)filename, (boolean)true));
            String uri = StringUtils.join(items, (String)"/");
            HashMap<String, String> requestParams = new HashMap<String, String>(docView.getParameters());
            requestParams.remove(FILE_PROPERTY_PATH_KEY);
            requestParams.remove(FILENAME_KEY);
            return URIUtils.addParametersToURIQuery((String)uri, requestParams);
        }
        return null;
    }

    public DocumentView getDocumentViewFromUrl(String url) {
        Pattern pattern = Pattern.compile(this.getPrefix() + URLPattern);
        Matcher m = pattern.matcher(url);
        if (m.matches() && m.groupCount() >= 4) {
            String query;
            Map requestParams;
            String server = m.group(1);
            String uuid = m.group(2);
            IdRef docRef = new IdRef(uuid);
            HashMap<String, String> params = new HashMap<String, String>();
            if (m.groupCount() >= 4) {
                String filePropertyPath = m.group(4);
                params.put(FILE_PROPERTY_PATH_KEY, filePropertyPath);
            }
            if (m.groupCount() >= 6) {
                String filename = m.group(6);
                try {
                    filename = URLDecoder.decode(filename, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    filename = StringUtils.toAscii((String)filename);
                }
                params.put(FILENAME_KEY, filename);
            }
            if (m.groupCount() >= 8 && (requestParams = URIUtils.getRequestParameters((String)(query = m.group(8)))) != null) {
                params.putAll(requestParams);
            }
            DocumentLocationImpl docLoc = new DocumentLocationImpl(server, (DocumentRef)docRef);
            return new DocumentViewImpl((DocumentLocation)docLoc, null, params);
        }
        return null;
    }

    public static String getBlobPropertyName(DocumentView docView) {
        return docView.getParameter(FILE_PROPERTY_PATH_KEY);
    }

    public static Blob getBlob(DocumentModel doc, DocumentView docView) {
        Blob blob = null;
        String propertyName = DocumentFileCodec.getBlobPropertyName(docView);
        if (propertyName != null) {
            blob = propertyName.startsWith("blobholder") ? DocumentFileCodec.getBlobViaBlobHolder(doc, propertyName) : (Blob)DocumentModelUtils.getPropertyValue((DocumentModel)doc, (String)propertyName);
        }
        return blob;
    }

    public static Blob getBlobViaBlobHolder(DocumentModel doc, String bhPath) {
        BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
        if (bh == null) {
            return null;
        }
        bhPath = bhPath.replace("blobholder:", "");
        try {
            if ("".equals(bhPath) || "0".equals(bhPath)) {
                return bh.getBlob();
            }
            int idx = Integer.parseInt(bhPath);
            return (Blob)bh.getBlobs().get(idx);
        }
        catch (Exception e) {
            log.error((Object)"Error whild using BlobHolder to retrieve Blob", (Throwable)e);
            return null;
        }
    }

    public static String getFilenamePropertyName(DocumentView docView) {
        String propertyPath = docView.getParameter(FILENAME_PROPERTY_PATH_KEY);
        return DocumentModelUtils.decodePropertyName((String)propertyPath);
    }

    public static String getFilename(DocumentModel doc, DocumentView docView) {
        String propertyName;
        String filename = docView.getParameter(FILENAME_KEY);
        if (filename == null && (propertyName = DocumentFileCodec.getFilenamePropertyName(docView)) != null) {
            filename = (String)DocumentModelUtils.getPropertyValue((DocumentModel)doc, (String)propertyName);
        }
        return filename;
    }
}

