/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.jboss.invocation.MarshalledValueInputStream;
import org.jboss.serial.io.JBossObjectInputStreamSharedTree;
import org.jboss.serial.io.JBossObjectOutputStreamSharedTree;

public class ObjectSerializationFactory {
    static boolean useJBossSerialization = false;

    public static ObjectOutputStream createObjectOutputStream(OutputStream out) throws IOException {
        return useJBossSerialization ? new JBossObjectOutputStreamSharedTree(out) : new ObjectOutputStream(out);
    }

    public static ObjectInputStream createObjectInputStream(byte[] bytes) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        if (useJBossSerialization) {
            return new JBossObjectInputStreamOverride(in);
        }
        return new MarshalledValueInputStream((InputStream)in);
    }

    public static boolean useJBossSerialization() {
        return useJBossSerialization;
    }

    static {
        String useJBossSerializationStr = System.getProperty("serialization.jboss", "true");
        useJBossSerialization = Boolean.valueOf(useJBossSerializationStr);
    }

    static class JBossObjectInputStreamOverride
    extends JBossObjectInputStreamSharedTree {
        public JBossObjectInputStreamOverride(InputStream input) throws IOException {
            super(input);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object readObjectOverride() throws IOException, ClassNotFoundException {
            ClassLoader older = this.getClassLoader();
            try {
                this.setClassLoader(Thread.currentThread().getContextClassLoader());
                Object object = super.readObjectOverride();
                return object;
            }
            finally {
                this.setClassLoader(older);
            }
        }
    }
}

