/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.transaction.Transaction;
import org.jboss.cache.CacheException;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.OptimisticTreeNode;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.OptimisticInterceptor;
import org.jboss.cache.marshall.JBCMethodCall;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jgroups.blocks.MethodCall;

public class OptimisticValidatorInterceptor
extends OptimisticInterceptor {
    public void setCache(TreeCache cache) {
        super.setCache(cache);
    }

    public Object invoke(MethodCall call) throws Throwable {
        JBCMethodCall m = (JBCMethodCall)call;
        InvocationContext ctx = this.getInvocationContext();
        Transaction tx = ctx.getTransaction();
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        Object retval = null;
        Method meth = m.getMethod();
        if (tx == null) {
            throw new CacheException("Not in a transaction");
        }
        switch (m.getMethodId()) {
            case 18: {
                this.validateNodes(gtx);
                break;
            }
            case 11: {
                this.commit(gtx);
                break;
            }
            case 12: {
                this.rollBack(gtx);
                break;
            }
            default: {
                retval = super.invoke(m);
            }
        }
        return retval;
    }

    private void validateNodes(GlobalTransaction gtx) throws CacheException {
        TransactionWorkspace workspace;
        try {
            workspace = this.getTransactionWorkspace(gtx);
        }
        catch (CacheException e) {
            throw new CacheException("unable to retrieve workspace", e);
        }
        Collection nodes = workspace.getNodes().values();
        this.log.debug((Object)"validating nodes");
        this.simpleValidate(nodes);
        this.log.debug((Object)"validated nodes");
    }

    private void simpleValidate(Collection nodes) throws CacheException {
        boolean trace = this.log.isTraceEnabled();
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            OptimisticTreeNode realNode;
            WorkspaceNode workspaceNode = (WorkspaceNode)it.next();
            Fqn fqn = workspaceNode.getFqn();
            if (trace) {
                this.log.trace((Object)("validating version for node " + fqn));
            }
            if ((realNode = (OptimisticTreeNode)this.cache._get(fqn)) == null && !workspaceNode.isCreated()) {
                throw new CacheException("Real node for " + fqn + " is null, and this wasn't newly created in this tx!");
            }
            if (workspaceNode.isCreated() || !realNode.getVersion().newerThan(workspaceNode.getVersion())) continue;
            throw new CacheException("DataNode [" + fqn + "] version " + ((OptimisticTreeNode)workspaceNode.getNode()).getVersion() + " is newer than workspace node " + workspaceNode.getVersion());
        }
    }

    private void commit(GlobalTransaction gtx) {
        TransactionWorkspace workspace;
        try {
            workspace = this.getTransactionWorkspace(gtx);
        }
        catch (CacheException e) {
            this.log.trace((Object)"we can't rollback", (Throwable)e);
            return;
        }
        this.log.debug((Object)"commiting validated changes ");
        Collection nodes = workspace.getNodes().values();
        boolean trace = this.log.isTraceEnabled();
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            WorkspaceNode wrappedNode = (WorkspaceNode)it.next();
            if (wrappedNode.isDeleted()) {
                if (trace) {
                    this.log.trace((Object)("Workspace node " + wrappedNode.getFqn() + " deleted; removing"));
                }
                DataNode dNode = wrappedNode.getNode();
                this.cache.notifyNodeRemove(dNode.getFqn(), true);
                if (dNode.getFqn().isRoot()) {
                    this.log.warn((Object)"Attempted to delete the root node");
                } else {
                    DataNode parent = (DataNode)dNode.getParent();
                    parent.removeChild(dNode.getName());
                }
                this.cache.notifyNodeRemoved(dNode.getFqn());
                this.cache.notifyNodeRemove(dNode.getFqn(), false);
                continue;
            }
            if (wrappedNode.isDirty()) {
                this.cache.notifyNodeModify(wrappedNode.getFqn(), true);
                OptimisticTreeNode current = (OptimisticTreeNode)wrappedNode.getNode();
                Map mergedChildren = wrappedNode.getMergedChildren();
                current.setChildren(mergedChildren);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("inserting merged data " + wrappedNode.getMergedData()));
                }
                Map mergedData = wrappedNode.getMergedData();
                current.put(mergedData, true);
                if (workspace.isVersioningImplicit()) {
                    current.setVersion(((DefaultDataVersion)wrappedNode.getVersion()).increment());
                } else {
                    if (trace) {
                        this.log.trace((Object)"Versioning is explicit; not attempting an increment.");
                    }
                    current.setVersion(wrappedNode.getVersion());
                }
                if (trace) {
                    this.log.trace((Object)("Setting version of node " + current.getName() + " from " + wrappedNode.getVersion() + " to " + current.getVersion()));
                }
                this.cache.notifyNodeModified(wrappedNode.getFqn());
                this.cache.notifyNodeModify(wrappedNode.getFqn(), false);
                continue;
            }
            if (trace) {
                this.log.trace((Object)("Merging node " + wrappedNode.getFqn() + " not necessary since the node is not dirty"));
            }
            this.cache.notifyNodeVisited(wrappedNode.getFqn());
        }
    }

    private void rollBack(GlobalTransaction gtx) {
        try {
            TransactionWorkspace workspace = this.getTransactionWorkspace(gtx);
            Map nodes = workspace.getNodes();
            nodes.clear();
        }
        catch (CacheException e) {
            this.log.info((Object)"Unable to roll back", (Throwable)e);
        }
    }
}

