/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.cache.CacheException;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.OptimisticTransactionEntry;
import org.jboss.cache.TransactionEntry;
import org.jboss.cache.TransactionTable;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeNode;
import org.jboss.cache.factories.NodeFactory;
import org.jboss.cache.interceptors.OptimisticInterceptor;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jgroups.blocks.MethodCall;

public class OptimisticCreateIfNotExistsInterceptor
extends OptimisticInterceptor {
    private static final List putMethods = new ArrayList(3);

    public void setCache(TreeCache cache) {
        super.setCache(cache);
    }

    public Object invoke(MethodCall m) throws Throwable {
        if (putMethods.contains(m.getMethod())) {
            Object[] args = m.getArgs();
            Fqn fqn = (Fqn)(args != null ? args[1] : null);
            if (fqn == null) {
                throw new CacheException("failed extracting FQN from method " + m);
            }
            if (!this.cache.exists(fqn)) {
                GlobalTransaction gtx = this.getInvocationContext().getGlobalTransaction();
                if (gtx != null) {
                    this.createNode(fqn, gtx, this.txTable);
                } else {
                    throw new CacheException("no transaction or temporary transaction found " + m);
                }
            }
        }
        return super.invoke(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNode(Fqn fqn, GlobalTransaction gtx, TransactionTable tx_table) throws CacheException {
        TransactionWorkspace workspace;
        if (fqn == null) {
            return;
        }
        TransactionEntry baseTransactionEntry = tx_table.get(gtx);
        OptimisticTransactionEntry transactionEntry = (OptimisticTransactionEntry)baseTransactionEntry;
        if (transactionEntry == null) {
            throw new CacheException("Unable to map global transaction " + gtx + " to transaction entry");
        }
        WorkspaceNode childWorkspaceNode = null;
        ArrayList<Fqn> nodesCreated = new ArrayList<Fqn>();
        int treeNodeSize = fqn.size();
        InvocationContext ctx = this.getInvocationContext();
        TransactionWorkspace transactionWorkspace = workspace = transactionEntry.getTransactionWorkSpace();
        synchronized (transactionWorkspace) {
            WorkspaceNode workspaceNode;
            DataVersion version = null;
            if (ctx.getOptionOverrides() != null && ctx.getOptionOverrides().getDataVersion() != null) {
                version = ctx.getOptionOverrides().getDataVersion();
                workspace.setVersioningImplicit(false);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(" Getting root fqn from workspace  for gtx " + gtx));
            }
            if ((workspaceNode = workspace.getNode(this.cache.getRoot().getFqn())) == null) {
                workspaceNode = NodeFactory.getInstance().createWorkspaceNode(this.cache.getRoot(), workspace);
                workspace.addNode(workspaceNode);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(" created root node " + workspaceNode + " in workspace " + gtx));
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(" Already found root node " + workspaceNode + " in workspace " + gtx));
            }
            Fqn tmpFqn = Fqn.ROOT;
            for (int i = 0; i < treeNodeSize; ++i) {
                boolean isTargetFqn = i == treeNodeSize - 1;
                Object childName = fqn.get(i);
                tmpFqn = new Fqn(tmpFqn, childName);
                this.log.debug((Object)(" Entering synchronized nodewrapper access  for gtx " + gtx));
                TreeNode tempchildNode = workspaceNode.getChild(childName);
                if (tempchildNode == null) {
                    WorkspaceNode tempCheckWrapper;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Child node " + childName + " doesn't exist.  Creating new node."));
                    }
                    if ((tempCheckWrapper = workspace.getNode(workspaceNode.getFqn())) == null || tempCheckWrapper.isDeleted()) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Parent node doesn't exist in workspace or has been deleted.  Adding to workspace in gtx " + gtx));
                        }
                        workspace.addNode(workspaceNode);
                    } else if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)(" Parent node " + workspaceNode.getFqn() + " exists in workspace " + gtx));
                    }
                    Fqn copy = (Fqn)tmpFqn.clone();
                    DataVersion versionToPassIn = null;
                    if (isTargetFqn && !workspace.isVersioningImplicit()) {
                        versionToPassIn = version;
                    }
                    DataNode tempNode = (DataNode)workspaceNode.createChild(childName, copy, (TreeNode)workspaceNode.getNode(), this.cache, versionToPassIn);
                    childWorkspaceNode = NodeFactory.getInstance().createWorkspaceNode(tempNode, workspace);
                    workspace.addNode(childWorkspaceNode);
                    childWorkspaceNode.markAsCreated();
                    nodesCreated.add(tmpFqn);
                } else {
                    childWorkspaceNode = workspace.getNode(tempchildNode.getFqn());
                    if (childWorkspaceNode == null || childWorkspaceNode.isDeleted()) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Child node doesn't exist in workspace or has been deleted.  Adding to workspace in gtx " + gtx));
                        }
                        childWorkspaceNode = NodeFactory.getInstance().createWorkspaceNode(tempchildNode, workspace);
                        if (!workspace.isVersioningImplicit()) {
                            childWorkspaceNode.setVersion(version);
                        }
                    } else if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)(" Already found " + tempchildNode.getFqn() + " node in workspace " + gtx));
                    }
                }
                workspaceNode = childWorkspaceNode;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("left synchronized nodewrapper access  for gtx " + gtx));
            }
        }
        if (nodesCreated.size() > 0) {
            Iterator it = nodesCreated.iterator();
            while (it.hasNext()) {
                Object temp = it.next();
                this.cache.notifyNodeCreated((Fqn)temp);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Notifying cache of node created in workspace " + temp));
            }
        }
    }

    static {
        putMethods.add(MethodDeclarations.putDataEraseMethodLocal);
        putMethods.add(MethodDeclarations.putDataMethodLocal);
        putMethods.add(MethodDeclarations.putKeyValMethodLocal);
    }
}

